package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.dto.video.UserVtotalDto;

/**
 * 视频奖励
 * Created by xuefeng on 2019/7/10.
 */
@AdvancedFeignClient
public interface RemoteVideoRewardService {

    /**
     * 根据用户查询
     *
     * @param userId
     * @return
     */
    UserVtotalDto getByUserId(Long userId);

    /**
     * 增加累计时长
     *
     * @param userId
     * @param time
     * @return
     */
    Boolean addLength(Long userId, Integer time);

    /**
     * 领取奖励
     *
     * @param userId
     * @return 目前是第几次领奖
     */
    Integer takeReward(Long userId);


}
