package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.dto.video.VideoDto;
import cn.com.duiba.tuia.ecb.center.dto.video.VideoListQuery;
import cn.com.duiba.tuia.ecb.center.dto.video.VideoSingleQuery;

import java.util.List;

/**
 * 激励视频
 * Created by xuefeng on 2019/6/11.
 */
@AdvancedFeignClient
public interface RemoteVideoService {

    /**
     * 获取视频列表
     * @param videoListReq
     * @return
     */
    List<VideoDto> getList(VideoListQuery videoListReq);

    /**
     * 开始播放
     * @param videoSingleQuery
     * @return
     */
    Boolean start(VideoSingleQuery videoSingleQuery);

    /**
     * 播放结束
     * @param videoSingleQuery
     * @return
     */
    Boolean finish(VideoSingleQuery videoSingleQuery);

    /**
     * 下载
     * @param videoSingleQuery
     * @return
     */
    Boolean download(VideoSingleQuery videoSingleQuery);

    /**
     * 查询特定视频素材
     * @param videoSingleQuery
     * @return
     */
    VideoDto getOne(VideoSingleQuery videoSingleQuery);

    /**
     * 操作
     * @param videoSingleQuery
     * @return
     */
    Boolean action(VideoSingleQuery videoSingleQuery);
}
