package cn.com.duiba.tuia.ecb.center.mix.dto.tree;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @author lijicong
 * @since 2020-03-26
 */
@Setter
@Getter
public class MixCashCowBoxConfigDTO implements Serializable {

    private static final long serialVersionUID = 5580253811904650662L;

    @ApiModelProperty(value = "活动ID")
    private String activityId;

    @ApiModelProperty(value = "出现概率")
    private Integer appearProb = 60;

    @ApiModelProperty(value = "成熟时间/生长间隔时间(s)")
    private Integer matureTime = 600;

    @ApiModelProperty(value = "每日数量上限")
    private Integer dayNumCeiling = 20;

    @ApiModelProperty(value = "仅开金币概率")
    private Integer onlyGoldProb = 20;

    @ApiModelProperty(value = "仅开金币下限")
    private Integer onlyGoldFloor = 3;

    @ApiModelProperty(value = "仅开金币上限")
    private Integer onlyGoldCeiling = 5;

    @ApiModelProperty(value = "开金币广告概率")
    private Integer goldAdProb = 80;

    @ApiModelProperty(value = "开金币上限")
    private Integer goldAdCeiling = 4;

    @ApiModelProperty(value = "开金币下限")
    private Integer goldAdFloor = 2;

    @ApiModelProperty(value = "位置数量上限")
    private Integer locationNumCeiling = 3;

    @ApiModelProperty(value = "插屏触发概率")
    private Integer screenAppearProb = 60;

    @ApiModelProperty(value = "触发的上限")
    private Integer screenNumCeiling = 3;

    @ApiModelProperty(value = "插屏金币奖励")
    private Integer screenGoldAmount = 1;

}
