package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixNewsHomeDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixNewsInfoDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixNewsPrizeDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixNewsRegionDto;
import cn.com.duiba.tuia.ecb.center.mix.req.MixNewsReq;
import cn.com.duiba.tuia.ecb.center.mix.req.MixPrizeReq;

import java.util.List;
import java.util.Set;

/**
 * RemoteMixNewsService
 * Created by zxw on 2020-04-20.
 */
@AdvancedFeignClient
public interface RemoteMixNewsService {
    /**
     * 渲染新闻页的广告及奖励内容
     *
     * @param req
     * @return
     */
    MixNewsHomeDto getHome(MixNewsReq req) throws BizException;


    /**
     * 渲染新闻页的广告及奖励内容
     *
     * @param req
     * @return
     */
    MixNewsInfoDto getInfo(MixNewsReq req) throws BizException;

    /**
     * 查询阅读奖励
     *
     * @param req
     * @return
     */
    MixNewsPrizeDto queryReadPrize(MixPrizeReq req) throws BizException;


    /**
     *  获取用户已读文章列表
     */
    Set<String> getReadMessageIds(MixNewsReq req) throws BizException;


}
