package cn.com.duiba.tuia.ecb.center.video.remoteservice.video;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.video.dto.config.BaseActivityVideoConfigDto;
import cn.com.duiba.tuia.ecb.center.video.dto.config.BaseThirdMediaConfigDto;
import cn.com.duiba.tuia.ecb.center.video.dto.config.BaseVideoConfigDto;
import cn.com.duiba.tuia.ecb.center.video.dto.config.TuiaVideoConfigDto;

import java.util.List;

/**
 * @author huangruodan
 * @version 创建时间：2020/4/15 1:45 下午
 */
@AdvancedFeignClient
public interface RemoteBaseVideoConfigService {

    /**
     * 保存视频广告配置
     * @param configDto 广告配置
     * @return 是否成功
     */
    Long saveBaseVideoConfig(BaseVideoConfigDto configDto) throws BizException;

    /**
     * 保存活动视频配置关系
     * @param baseActivityVideoConfigDto 配置
     * @return 是否正确
     */
    Boolean saveBaseActivityVideoConfig(BaseActivityVideoConfigDto baseActivityVideoConfigDto) throws BizException;

    /**
     * 保存三方媒体配置
     * @param thirdMediaConfig 三方媒体配置
     * @return 是否成功
     */
    Boolean saveThirdMediaConfig(BaseThirdMediaConfigDto thirdMediaConfig) throws BizException;

    /**
     * 保存推啊激励视频配置
     * @param tuiaVideoConfigDto
     * @return 是否成功
     */
    Boolean saveTuiaVideoConfig(TuiaVideoConfigDto tuiaVideoConfigDto) throws BizException;


    /**
     * 获取该活动的激励视频配置
     * @param activityId 活动id
     * @return 活动配置
     */
    BaseVideoConfigDto getBaseVideoConfig(Long activityId) throws BizException;


    /**
     * 获取三方媒体配置
     * @param thirdMediaType 媒体类型
     * @return 三方媒体配置
     */
    BaseThirdMediaConfigDto getBaseThirdMediaConfig(Integer thirdMediaType) throws BizException;

    /**
     * 根据活动获取视频配置
     * @param activityId 活动id
     * @param thirdType 媒体类型
     * @return 视频配置
     */
    BaseActivityVideoConfigDto getActivityVideoConfig(Long activityId, Integer thirdType) throws BizException;

    /**
     * 获取推啊激励视频
     * @return 激励视频
     */
    List<TuiaVideoConfigDto> getTuiaVideoConfigList(Long activityId) throws BizException;

    /**
     * 保存活动视频配置关系
     * @param configList 配置
     * @return 是否正确
     */
    Boolean saveBaseActivityVideoConfigList(List<BaseActivityVideoConfigDto> configList, Long activityId) throws BizException;
}
