package cn.com.duiba.tuia.ecb.center.happy.dto;


import cn.com.duiba.tuia.ecb.center.mix.dto.BaseDto;

import java.io.Serializable;

/**
 * 奖励配置
 */
public class SignRewardRuleItemDTO extends BaseDto implements Serializable {

    private static final long serialVersionUID = -1695582366948553867L;

    /**
     * 签到规则在json配置中的key
     */
    public static final String KEY_DAYS = "days";
    public static final String KEY_CREDITS = "credits";
    public static final String KEY_ACTIVITY_COUNT = "activityCount";
    public static final String KEY_RED_COUNT = "redCount";
    public static final String KEY_PRIZE_CHANCE = "prizeChance";

    /**
     * 天数，不同签到规则具有不同意思
     */
    private Integer days;
    /**
     * 加积分数量
     */
    private Integer credits = 0;
    /**
     * 加活动次数数量
     */
    private Integer activityCount = 0;
    /**
     * 红包数量
     */
    private Integer redCount=0;

    /**
     * 奖品池抽奖机会
     */
    private Integer prizeChance=0;

    public boolean isValid(){
        return (credits != null && credits > 0) || (activityCount != null && activityCount > 0);
    }

    public Integer getDays() {
        return days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getActivityCount() {
        return activityCount;
    }

    public void setActivityCount(Integer activityCount) {
        this.activityCount = activityCount;
    }

    public Integer getRedCount() {
        return redCount;
    }

    public void setRedCount(Integer redCount) {
        this.redCount = redCount;
    }

    public Integer getPrizeChance() {
        return prizeChance;
    }

    public void setPrizeChance(Integer prizeChance) {
        this.prizeChance = prizeChance;
    }
}
