package cn.com.duiba.tuia.ecb.center.mix.enums.video;

import java.util.Objects;

/**
 * [工具类赚钱页]激励场景
 *
 * @author zhangbaiqiang
 * @date 2020/1/16
 */
public enum RewardSceneType {

    CASH_COW_DOUBLE_VIDEO(1, "摇钱树-激励视频翻倍"),
    CASH_COW_DOUBLE_ACTIVITY(2, "摇钱树-激励互动翻倍"),
    SIGN_IN_REPLENISH(3, "签到-补签"),
    MISSION_REWARD_VIDEO(4, "任务-激励视频"),
    MISSION_REWARD_ACTIVITY(5, "任务-激励互动"),
    ;

    private Integer type;
    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    RewardSceneType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 判断是否出激励互动
     *
     * @param type 激励场景类型
     * @return true.出激励互动;false.出激励视频
     */
    public static boolean isRewardActivity(Integer type) {
        return Objects.equals(type, CASH_COW_DOUBLE_ACTIVITY.getType())
                || Objects.equals(type, MISSION_REWARD_ACTIVITY.getType());
    }
}
