package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixCallbackLimitConfigDto;
import cn.com.duiba.tuia.ecb.center.mix.dto.MixConfigTemplateDTO;
import cn.com.duiba.tuia.ecb.center.mix.dto.video.MixRewardVideoConfigDto;

/**
 * [工具类赚钱页]配置接口
 *
 * @author zhangbaiqiang
 * @date 2020/1/20
 */
@AdvancedFeignClient
public interface RemoteMixConfigService {

    /**
     * 获取媒体的配置模板
     */
    MixConfigTemplateDTO getConfigTemplateByAppId(Long appId);

    /**
     * 获取配置模板
     */
    MixConfigTemplateDTO getConfigTemplate(Long configTemplateId);

    /**
     * 更新媒体配置
     *
     * @param appId 媒体id
     * @param configTemplate 配置模板
     */
    void updateAppConfig(Long appId, MixConfigTemplateDTO configTemplate);

    /**
     * 查询激励视频默认投放规则配置
     *
     * @return 激励视频投放规则配置
     */
    MixRewardVideoConfigDto getRewardVideoDefaultConfig();

    /**
     * 更新激励视频默认投放规则配置
     *
     * @return 激励视频投放规则配置
     */
    void updateRewardVideoDefaultConfig(MixRewardVideoConfigDto config);

    /**
     * 查询激励视频投放规则配置
     *
     * @param id 规则配置id
     * @return 激励视频投放规则配置
     */
    MixRewardVideoConfigDto getRewardVideoConfig(Long id);

    /**
     * 新增激励视频投放规则配置
     *
     * @param config 配置
     * @return 配置id
     */
    Long addRewardVideoConfig(MixRewardVideoConfigDto config);

    /**
     * 查询回调风控规则配置
     *
     * @return 回调风控规则配置
     */
    MixCallbackLimitConfigDto getCallbackLimitDefaultConfig();

    /**
     * 更新回调风控规则配置
     *
     * @param config 回调风控规则配置
     */
    void updateCallbackLimitDefaultConfig(MixCallbackLimitConfigDto config);

    /**
     * 清除媒体配置缓存，立即生效
     */
    void clearAppConfigCache(Long appId);
}
