package cn.com.duiba.tuia.ecb.center.exception;

/**
 * @author ElinZhou
 * @version $Id: ErrorCode.java , v 0.1 2017/12/28 下午3:24 ElinZhou Exp $
 */
public enum ErrorCode {
    SYSTEM_EXCEPTION("9999999", "系统异常"),
    USER_NOT_EXIST("0300001", "用户不存在"),
    LACK_OF_CHANGE_BALANCE("0300002", "零钱余额不足"),
    APP_NOT_EXIST("0300003", "当前应用已下架，记得早些领取哦"),
    APP_STATUS_ERROR("0300004", "该应用未达到领取条件"),
    APP_TODAY_ACEPTED("0300005", "你已经领取过这份奖励啦~"),
    APP_EXPIRE("0300006", "这份奖励已过期~"),
    APP_ACCEPT_ERROR("0300007", "你的奖励领取异常~"),
    WITHDRAW_UPDATE_ERROR("0310000", "提现更新状态异常"),

    /*
     *  工具类赚钱页错误码
     */
    // 通用
    E0400001("0400001", "参数为空"),
    E0400002("0400002", "未查询到用户信息"),
    E0400003("0400003", "无效的业务类型"),
    E0400004("0400004", "正在处理中"),
    E0400005("0400005", "更新用户设备信息失败"),
    E0400006("0400006", "查询奖励信息异常"),
    E0400007("0400007", "查询媒体信息异常"),
    E0400008("0400008", "查询媒体日收益信息异常"),
    E0400009("0400009", "批量更新媒体日收益信息异常"),
    E0400010("0400010", "更新媒体日收益信息异常"),
    E0400011("0400011", "更新用户收益异常"),

    // 签到
    E0401001("0401001", "没有补签机会了哦~"),
    E0401002("0401002", "用户未初始化"),
    E0401003("0401003", "只能补签当前签到周期时间"),
    E0401004("0401004", "补签失败"),
    E0401005("0401005", "签到失败"),
    E0401006("0401006", "领取新手奖励失败"),
    E0401007("0401007", "查询签到信息失败"),
    E0401008("0401008", "查询昨日收益失败"),
    E0401009("0401009", "更新签到配置失败"),
    E0401010("0401010", "查询签到配置失败"),
    E0401011("0401011", "已经领取过新手奖励"),
    E0401012("0401012", "新手引导步骤更新失败"),
    E0401013("0401013", "修改签到时间失败"),
    E0401014("0401014", "未查询到签到记录"),
    E0401015("0401015", "签到时间转换异常"),

    // 收益
    E0402001("0402001", "时间戳校验失败"),
    E0402002("0402002", "签名校验失败"),
    E0402003("0402003", "用户校验失败"),
    E0402004("0402004", "token 校验失败"),
    E0402005("0402005", "超过收益上限"),
    E0402006("0402006", "重复请求"),
    E0402007("0402007", "没查到收益信息"),
    E0402008("0402008", "您的余额不足，快去赚金币吧！"),
    E0402009("0402009", "获取用户收益信息失败"),
    E0402010("0402010", "用户提现失败"),
    E0402011("0402011", "用户提现失败"),
    E0402012("0402012", "获取提现详情失败"),
    E0402013("0402013", "获取正在提现的订单失败"),
    E0402014("0402014", "未查到提现记录"),
    E0402015("0402015", "提现记录与用户信息不一致"),
    E0402016("0402016", "获取提现信息失败"),
    E0402017("0402017", "获取提现配置失败"),
    E0402018("0402018", "提现失败"),
    E0402019("0402019", "没查到订单信息"),
    E0402020("0402020", "没查到媒体配置信息"),
    E0402021("0402021", "没查到当日收益信息"),

    // 用户
    E0403001("0403001", "未查询到用户信息"),

    // E041 开头为摇钱树相关ERROR
    E0404001("0404001", "用户信息未找到"),
    E0404002("0404002", "用户已经存在"),
    E0404003("0404003", "用户已经种过树"),
    E0404004("0404004", "查询摇钱树配置失败"),
    E0404005("0404005", "设置摇钱树配置失败"),
    E0404006("0404006", "有果实未成熟"),
    E0404007("0404007", "添加新果实失败"),
    E0404008("0404008", "已达成熟果实上线"),
    E0404009("0404009", "用户未种过树"),
    E0404010("0404010", "摇钱树初始化失败"),
    E0404011("0404011", "用户种树失败"),
    E0404012("0404012", "添加果实失败"),
    E0404013("0404013", "用户收取果实失败"),
    E0404014("0404014", "无果实可以收取"),

    // 配置相关
    E0405001("0405001", "查询任务配置失败"),
    E0405002("0405002", "更新任务配置失败"),
    E0405003("0405003", "更新新手引导配置失败"),
    E0405004("0405004", "查询新手引导配置失败"),
    E0405005("0405005", "更新支付宝直投页配置失败"),
    E0405006("0405006", "获取支付宝直投页配置失败"),
    E0405007("0405007", "更新任务具体配置失败"),
    E0405008("0405008", "未查询到任务信息"),
    E0405009("0405009", "未查询到该APP的配置"),
    E0405010("0405010", "未查询到支付宝直投页配置"),
    E0405011("0405011", "新手引导配置不能为空"),
    E0405012("0405012", "更新激励视频配置失败"),

    // 任务
    E0406001("0406001", "查询任务列表失败"),
    E0406002("0406002", "更新任务进度失败"),
    E0406003("0406003", "任务已经完成"),
    E0406004("0406004", "查询任务模板列表失败"),
    E0406005("0406005", "任务按钮配置不能为空"),
    E0406006("0406006", "任务条件配置不能为空"),
    E0406007("0406007", "任务奖励配置不能为空"),


    // 第三方
    E0407001("0407001", "时间戳校验失败"),
    E0407002("0407002", "签名校验失败"),
    E0407003("0407003", "appToken 校验失败"),
    E0407004("0407004", "奖励回调异常"),
    E0407005("0407005", "重复请求"),
    E0407006("0407006", "上报间隔过短"),
    E0407007("0407007", "游戏时长未达标"),
    E0407008("0407008", "奖励超出上限"),
    ;

    private String code;

    private String description;

    ErrorCode(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

}
