package cn.com.duiba.tuia.ecb.center.mix.enums;

import java.util.Objects;

/**
 * [工具类赚钱页]任务条件类型
 *
 * @author zhangbaiqiang
 * @date 2020/1/14
 */
public enum MissionConditionType {

    WULI_NEWS(1, "看新闻"),
    NOVEL(2, "看小说"),
    DDZ_GAME(3, "蛋蛋赚试玩广告"),
    REWARD_VIDEO(4, "激励视频"),
    REWARD_ACTIVITY(5, "激励互动"),
    BAOQU_GAME(6, "豹趣游戏"),
    REWARD_NATIVE(7, "插屏互动"),
    XIANWAN(8, "闲玩"),
    WULI_VIDEO(9, "唔哩视频"),
    READ_NEWS(10, "新版读新闻"),
    DIANHUN_GAME(11, "电魂游戏"),


    ////////////////////////////////////////////////////////////////////////////
    // 针对媒体任务定制开发
    REWARD_MEDIA_MISSION101(101, "媒体任务(即时奖励，不需要媒体对接回调接口)"),
    REWARD_MEDIA_MISSION102(102, "媒体任务(即时奖励，不需要媒体对接回调接口)"),
    REWARD_MEDIA_MISSION103(103, "媒体任务(即时奖励，不需要媒体对接回调接口)"),
    REWARD_MEDIA_MISSION104(104, "媒体任务(即时奖励，不需要媒体对接回调接口)"),
    REWARD_MEDIA_MISSION105(105, "媒体任务(即时奖励，不需要媒体对接回调接口)"),
    REWARD_MEDIA_MISSION106(106, "媒体任务(即时奖励，不需要媒体对接回调接口)"),
    REWARD_MEDIA_MISSION107(107, "媒体任务(即时奖励，不需要媒体对接回调接口)"),
    REWARD_MEDIA_MISSION108(108, "媒体任务(即时奖励，不需要媒体对接回调接口)"),
    REWARD_MEDIA_MISSION109(109, "媒体任务(即时奖励，不需要媒体对接回调接口)"),

    ////////////////////////////////////////////////////////////////////////////
    // 针对媒体任务定制开发
    REWARD_TUIA_BLOCK201(201, "推啊活动内部区块(即时奖励，不需要媒体对接回调接口)"),
    REWARD_TUIA_BLOCK202(202, "推啊活动内部区块(即时奖励，不需要媒体对接回调接口)"),
    REWARD_TUIA_BLOCK203(203, "推啊活动内部区块(即时奖励，不需要媒体对接回调接口)"),
    REWARD_TUIA_BLOCK204(204, "推啊活动内部区块(即时奖励，不需要媒体对接回调接口)"),
    REWARD_TUIA_BLOCK205(205, "推啊活动内部区块(即时奖励，不需要媒体对接回调接口)"),
    REWARD_TUIA_BLOCK206(206, "推啊活动内部区块(即时奖励，不需要媒体对接回调接口)"),
    REWARD_TUIA_BLOCK207(207, "推啊活动内部区块(即时奖励，不需要媒体对接回调接口)"),
    REWARD_TUIA_BLOCK208(208, "推啊活动内部区块(即时奖励，不需要媒体对接回调接口)"),
    REWARD_TUIA_BLOCK209(209, "推啊活动内部区块(即时奖励，不需要媒体对接回调接口)"),
    ;

    private Integer type;
    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    MissionConditionType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static MissionConditionType getByType(int value) {
        for (MissionConditionType enums : MissionConditionType.values()) {
            if (enums.getType() == value) {
                return enums;
            }
        }
        return null;
    }

    /**
     * 判断是否是激励类型的任务条件
     */
    public static boolean isReward(Integer conditionType) {
        return Objects.equals(conditionType, REWARD_VIDEO.getType())
                || Objects.equals(conditionType, DIANHUN_GAME.getType())
                || Objects.equals(conditionType, REWARD_ACTIVITY.getType())
                || Objects.equals(conditionType, REWARD_NATIVE.getType())
                || isRewardMedia(conditionType)
                || isRewardTuiaBlock(conditionType);
    }

    /**
     * 针对媒体任务定制开发(跳转外部链接直接发奖)
     *
     * @param conditionType
     * @return
     */
    private static boolean isRewardMedia(Integer conditionType) {
        return Objects.equals(conditionType, REWARD_MEDIA_MISSION101.getType())
                || Objects.equals(conditionType, REWARD_MEDIA_MISSION102.getType())
                || Objects.equals(conditionType, REWARD_MEDIA_MISSION103.getType())
                || Objects.equals(conditionType, REWARD_MEDIA_MISSION104.getType())
                || Objects.equals(conditionType, REWARD_MEDIA_MISSION105.getType())
                || Objects.equals(conditionType, REWARD_MEDIA_MISSION106.getType())
                || Objects.equals(conditionType, REWARD_MEDIA_MISSION107.getType())
                || Objects.equals(conditionType, REWARD_MEDIA_MISSION108.getType())
                || Objects.equals(conditionType, REWARD_MEDIA_MISSION109.getType());
    }

    /**
     * 针对推啊活动内部区块定制开发(跳转直接发奖)
     *
     * @param conditionType
     * @return
     */
    private static boolean isRewardTuiaBlock(Integer conditionType) {
        return Objects.equals(conditionType, REWARD_TUIA_BLOCK201.getType())
                || Objects.equals(conditionType, REWARD_TUIA_BLOCK202.getType())
                || Objects.equals(conditionType, REWARD_TUIA_BLOCK203.getType())
                || Objects.equals(conditionType, REWARD_TUIA_BLOCK204.getType())
                || Objects.equals(conditionType, REWARD_TUIA_BLOCK205.getType())
                || Objects.equals(conditionType, REWARD_TUIA_BLOCK206.getType())
                || Objects.equals(conditionType, REWARD_TUIA_BLOCK207.getType())
                || Objects.equals(conditionType, REWARD_TUIA_BLOCK208.getType())
                || Objects.equals(conditionType, REWARD_TUIA_BLOCK209.getType());
    }
}
