package cn.com.duiba.tuia.ecb.center.draw.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * [碎片抽奖]活动配置表
 */
@Getter
@Setter
public class DrawActivityConfigDTO implements Serializable {
    private static final long serialVersionUID = 990531922381398314L;

    private Long id;

    @ApiModelProperty(value = "活动ID")
    private Long activityId;

    @ApiModelProperty(value = "基础次数")
    private Integer baseTimes;

    @ApiModelProperty(value = "额外次数")
    private Integer extraTimes;

    @ApiModelProperty(value = "每次碎片奖励数量下限")
    private Integer fragmentFloor;

    @ApiModelProperty(value = "当日可获取的总碎片数量上限")
    private Integer dayFragmentPlatfond;

    @ApiModelProperty(value = "最小翻倍数")
    private Integer minMultiple;

    @ApiModelProperty(value = "最大翻倍数")
    private Integer maxMultiple;

    @ApiModelProperty(value = "签到配置")
    private List<DrawSignConfigDto> signConfig;

    @ApiModelProperty(value = "宝箱配置")
    private List<Integer> boxConfig;

    @ApiModelProperty(value = "抽奖配置")
    private List<DrawLuckConfigDto> drawConfig;

    @ApiModelProperty(value = "活动版本")
    private Long activityVersion;

    @ApiModelProperty(value = "活动开始时间")
    private Date startTime;

    @ApiModelProperty(value = "活动结束时间")
    private Date endTime;

}