package cn.com.duiba.tuia.ecb.center.draw.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.draw.dto.*;
import cn.com.duiba.tuia.ecb.center.draw.req.DrawFragmentActivityConfigReq;
import cn.com.duiba.tuia.ecb.center.draw.rsp.DrawAppConfigRsp;

import java.util.List;

@AdvancedFeignClient
/*
 * 抽奖活动配置接口 V1
 */
public interface RemoteDrawConfigService {

    List<DrawFragmentInfoDTO> insertFragmentInfoConfig(List<DrawFragmentInfoDTO> dtos) throws BizException;

    int updateFragmentInfo(DrawFragmentInfoDTO dto) throws BizException;

    DrawFragmentInfoDTO getFragmentInfoById(Long id) throws BizException;

    List<DrawFragmentInfoDTO> getFragmentInfoByIds(List<Long> ids) throws BizException;

    List<DrawFragmentInfoDTO> getFragmentInfoBySizes(Integer size) throws BizException;

    DrawActivityConfigDTO saveNormalActivityConfig(DrawFragmentActivityConfigReq req) throws BizException;

    DrawActivityConfigDTO getActivityConfig(Long id, Long activityId) throws BizException;

    DrawActivityConfigDTO getActivityConfigById(Long id) throws BizException;

    DrawActivityConfigDTO getActivityConfigByActivityId(Long activityId) throws BizException;

    int saveActivitySignConfig(Long activityId, List<DrawSignConfigDto> drawSignConfigDtos) throws BizException;

    int saveActivityDrawConfig(Long activityId, List<DrawLuckConfigDto> drawLuckConfigDtos) throws BizException;

    int saveActivityBoxConfig(Long activityId, List<Integer> drawBoxConfigDtos) throws BizException;

    List<DrawActivityFragmentDTO> saveDrawActivityFragmentConfig(List<DrawActivityFragmentDTO> drawActivityFragmentDTOList) throws BizException;

    List<DrawActivityFragmentDTO> getDrawActivityFragmentConfigByActivityId(Long activityId) throws BizException;

    int deleteDrawActivityFragmentConfigByActivityId(Long activityId) throws BizException;

    int deleteDrawActivityFragmentConfigById(Long id) throws BizException;

    DrawMediaFragmentDTO saveMediaFragmentConfig(DrawMediaFragmentDTO drawMediaFragmentDTO) throws BizException;

    int deleteDrawAppActivityConfigByAppId(Long appId) throws BizException;

    int deleteDrawAppActivityConfigById(Long id) throws BizException;

    DrawMediaFragmentDTO getDrawAppActivityConfigByAppId(Long appId, Long activityId) throws BizException;

    DrawAppConfigRsp getDrawAppConfig(Long appId, Long activityId) throws BizException;

}
