package cn.com.duiba.tuia.ecb.center.mix.enums;

import java.util.Objects;

/**
 * @Author: xianhongwei
 * @Time: 2020-01-13 20:32
 * @Desc:
 */
public enum MixWithdrawStage {

    FIVE(1, 500, "五元"),
    TEN(2, 1000, "十元"),
    FIFTEEN(3, 1500, "十五元");

    private Integer type;
    private Integer amount;
    private String desc;

    public Integer getType() {
        return type;
    }

    public Integer getAmount() {
        return amount;
    }

    public String getDesc() {
        return desc;
    }

    MixWithdrawStage(Integer type, Integer amount, String desc) {
        this.type = type;
        this.amount = amount;
        this.desc = desc;
    }

    public static Integer getAmountByType(Integer type) {
        for (MixWithdrawStage stage : MixWithdrawStage.values()) {
            if (Objects.equals(type, stage.getType())) {
                return stage.getAmount();
            }
        }
        return 0;
    }


    public static MixWithdrawStage getByType(Integer type) {
        for (MixWithdrawStage stage : MixWithdrawStage.values()) {
            if (Objects.equals(type, stage.getType())) {
                return stage;
            }
        }
        return null;
    }

}
