package cn.com.duiba.tuia.ecb.center.withdraw.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.withdraw.req.WithdrawReq;
import cn.com.duiba.tuia.ecb.center.withdraw.rsp.WithdrawRsp;

/**
 * @ClassName RemoteEcbWithdrawService
 * @Description 激励场景提现
 * @Author Zaizai
 * @Date 2020/10/28 10:40 上午
 **/
@AdvancedFeignClient
public interface RemoteEcbWithdrawService {

    /**
     * 校验是否有体现资格
     * @param withdrawReq
     * @return
     */
    Boolean checkWithdrawCondition(WithdrawReq withdrawReq) throws BizException;

    /**
     * 提现
     * @param withdrawReq
     * @return
     */
    WithdrawRsp doWithdraw(WithdrawReq withdrawReq) throws BizException ;

    /**
     * 获取未完成业务处理的订单号
     * @param withdrawReq
     * @return
     */
    String selectIncompleteOrderId(WithdrawReq withdrawReq) throws BizException ;

    /**
     * 插入提现记录
     * @param withdrawReq
     */
    void insertWithdrawRecord(WithdrawReq withdrawReq) throws BizException ;

}
