package cn.com.duiba.tuia.ecb.center.sale.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.sale.dto.SaleDto;
import cn.com.duiba.tuia.ecb.center.sale.dto.SaleItemDto;
import cn.com.duiba.tuia.ecb.center.sale.dto.SaleVideoActivityConfigDto;
import cn.com.duiba.tuia.ecb.center.sale.dto.SaleVideoSrcDto;
import cn.com.duiba.tuia.ecb.center.sale.req.ReportVideoReq;
import cn.com.duiba.tuia.ecb.center.sale.req.ResetForTestReq;
import cn.com.duiba.tuia.ecb.center.sale.req.SaleUserReq;
import cn.com.duiba.tuia.ecb.center.sale.req.SubmitOrderReq;

import java.util.List;

/**
 * @author huangruodan
 * @version 创建时间：2020/6/5 2:22 下午
 */
@AdvancedFeignClient
public interface RemoteSaleService {

    /**
     * 初始化
     * @param req 用户信息
     * @return 初始化
     */
    SaleDto initialize(SaleUserReq req) throws BizException;

    /**
     * 上报视频
     * @param videoReq 用户信息、视频id
     * @return
     */
    Boolean reportVideo(ReportVideoReq videoReq) throws BizException;


    /**
     * 保存订单
     * @param req 订单信息
     * @return 是否成功
     */
    SaleDto saveSaleOrder(SubmitOrderReq req) throws BizException;


    /**
     * 清除商品缓存
     * @param itemId
     * @return
     */
    Boolean clearItemIdCache(String itemId);


    /**
     * 保存视频配置
     * @param videoConfigDto
     * @return
     */
    Boolean saveVideoConfig(SaleVideoActivityConfigDto videoConfigDto) throws BizException;

    /**
     * 查询视频
     * @param activityId
     * @return
     */
    List<SaleVideoSrcDto> getVideoSrcList(Long activityId) throws BizException;


    /**
     * 保存商品配置
     * @param item 配置
     * @return
     */
    Boolean saveItemConfig(SaleItemDto item) throws BizException;


    /**
     * 获取商品配置（非百奇）
     * @param itemId
     * @return
     */
    SaleItemDto getSystemItemConfig(String itemId) throws BizException;

    /**
     * 换天
     * @param resetForTestReq
     * @return
     */
    Boolean resetForTest(ResetForTestReq resetForTestReq) throws BizException;

    /**
     * 设置金额
     * @param activityId
     * @param cash
     * @return
     */
    Boolean setSaleUserCash(Long activityId, Long cash);
}

