package cn.com.duiba.tuia.ecb.center.mix.dto.clock;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * [工具类赚钱页]打卡配置
 */
@Getter
@Setter
public class MixClockConfigDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "活动ID")
    private Long activityId;

    @ApiModelProperty(value = "奖池系数")
    private Integer pondFactor;

    @ApiModelProperty(value = "随机总人数")
    private Integer randomPersonNum;

    @ApiModelProperty(value = "每日消耗金币")
    private Integer consumeAmount;

    @ApiModelProperty(value = "瓜分区间下限")
    private Double amountFloor;

    @ApiModelProperty(value = "瓜分区间上限")
    private Double amountCeiling;


    public static final MixClockConfigDTO DEFAULT;

    static {
        DEFAULT = new MixClockConfigDTO();
        DEFAULT.setPondFactor(10);
        DEFAULT.setRandomPersonNum(100);
        DEFAULT.setConsumeAmount(10);
        DEFAULT.setAmountFloor(1.5);
        DEFAULT.setAmountCeiling(4.0);
    }

}