package cn.com.duiba.tuia.ecb.center.video.enums;

import cn.com.duiba.tuia.ecb.center.mix.enums.video.RewardVideoType;

import java.util.Objects;

public enum VideoSourceMappingType {

    TUIA(0, RewardVideoType.TUIA),
    SHCC(97, RewardVideoType.SHCC),
    JC(96, RewardVideoType.JC),
    SHXG(99, RewardVideoType.SHXG),
    TUIA_ADX(98, RewardVideoType.TUIA_ADX)
    ;

    public int getTypeCode() {
        return typeCode;
    }

    public RewardVideoType getRewardVideoType() {
        return rewardVideoType;
    }

    private int typeCode;

    private RewardVideoType rewardVideoType;

    VideoSourceMappingType(int typeCode, RewardVideoType rewardVideoType) {
        this.typeCode = typeCode;
        this.rewardVideoType = rewardVideoType;
    }

    public static RewardVideoType getRewardVideoTypeByCode(int typeCode) {
        for (VideoSourceMappingType mappingType : VideoSourceMappingType.values()) {
            if (Objects.equals(mappingType.getTypeCode(), typeCode))
                return mappingType.getRewardVideoType();
        }
        return null;
    }
}
