package cn.com.duiba.tuia.ecb.center.mix.enums;

/**
 * [工具类赚钱页]跳转类型枚举
 *
 * @author zhangbaiqiang
 * @date 2020/1/14
 */
public enum RedirectType {

    TUIA_ACTIVITY(1, "推啊内部活动"),
    EXTERNAL_URL(2, "外部链接"),
    MIX_RATE(3, "混合分流出"),
    LOTTERY(4, "推啊内部模块"),
    BAIDU_EMBED(1, "百度嵌入式广告"),
    ;

    private Integer type;
    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    RedirectType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static RedirectType getByDesc(String desc) {
        RedirectType[] arr = RedirectType.values();
        for (RedirectType redirectType : arr) {
            if (desc.equals(redirectType.desc)) {
                return redirectType;
            }
        }
        return null;
    }


}
