package cn.com.duiba.tuia.ecb.center.video.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 审核状态
 *
 * @author ElinZhou
 * @version $Id: ApplyStatus.java , v 0.1 2018/1/2 下午3:50 ElinZhou Exp $
 */
public enum ApplyStatus {
    /**
     * 申请中
     */
    PROCESS(0,"申请中"),

    /**
     * 通过
     */
    PASS(1,"通过"),

    /**
     * 拒绝
     */
    REJECT(2,"拒绝"),

    /**
     * 驳回
     */
    TURN_DOWN(3,"驳回"),
    

    ;
    private static final Map<Integer, ApplyStatus> CACHE = Maps.uniqueIndex(Arrays.asList(ApplyStatus
            .values()), ApplyStatus::getCode);

    private Integer code;
    private String desc;

    ApplyStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);
    }

    public static ApplyStatus of(Integer aCode) {
        return CACHE.get(aCode);
    }

}
