package cn.com.duiba.tuia.ecb.center.draw.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.draw.dto.v2.DrawV2ActivityConfigDTO;
import cn.com.duiba.tuia.ecb.center.draw.req.DrawV2ActivityConfigReq;
import cn.com.duiba.tuia.ecb.center.draw.rsp.v2.DrawV2ActivityConfigRsp;
import cn.com.duiba.tuia.ecb.center.exception.EcbCenterException;

/**
 * @ClassName RemoteDrawV2ConfigService
 * @Description 大转盘2.0活动配置
 * @Author Zaizai
 * @Date 2021/3/10 10:04 上午
 **/
@AdvancedFeignClient
public interface RemoteDrawV2ConfigService {

    /**
     * 保存活动及兑奖配置
     * @param activityId
     * @param drawV2ActivityConfigReq
     * @return
     */
    DrawV2ActivityConfigRsp saveOrUpdateConfig(Long activityId, DrawV2ActivityConfigReq drawV2ActivityConfigReq) throws BizException;

    /**
     * 查询活动及兑奖配置
     * @param activityId
     * @return
     */
    DrawV2ActivityConfigRsp queryDrawV2Config(Long activityId);




}
