package cn.com.duiba.tuia.ecb.center.happy.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 消消乐额外配置
 * Created by zxw on 2021-05-12.
 */

@Getter
@Setter
public class HappyClearExtConfigDTO implements Serializable {


    private static final long serialVersionUID = -6608391970573341088L;
    /**
     * 每日的初始化体力
     */
    private Integer defaultPower;

    /**
     * 体力的最大值，达到后不再恢复
     */
    private Integer maxPower;

    /**
     * 每日随机获得的碎片最大值（当前获得的存放在redis）
     */
    private Integer maxRandomCoin;

    /**
     * 视频最大播放次数
     */
    private Integer videoMaxTimes;


    /**
     * 看视频能获得的最大体力值
     */
    private Integer videoMaxPower;

    /**
     * 额外宝箱配置
     */
    private List<HappyClearExtraBoxConfigDTO> boxConfig;


    /**
     * 新人任务完成后补偿到指定的值
     */
    private Integer newUserCompensate;

    /**
     * 补偿关卡
     */
    private Integer newUserCompensateLevel;


}
