package cn.com.duiba.tuia.ecb.center.happy.enums;

/**
 * @author: xuesong
 * @Date: 2020/3/20 2:14 下午
 * @Description: 道具类型
 */
public enum PropTypeEnum {
    //WING(1, "元宝"),
    BOMB(11, "炸弹"),
    HAMMER(21, "锤子"),
    STEP(31, "步数"),
    POWER(41, "体力"),
    STAR(51, "星星"),
    BOX(61, "宝箱"),
    SENIOR_COIN(71, "高级货币"),
    GAME_STEP(101, "局内步数"),;


    PropTypeEnum(Integer type, String message) {
        this.type = type;
        this.message = message;
    }

    private Integer type;

    private String message;

    private Integer sort;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public static PropTypeEnum of(Integer type) {
        for (PropTypeEnum propTypeEnum : PropTypeEnum.values()) {
            if (propTypeEnum.getType().equals(type)) {
                return propTypeEnum;
            }
        }
        return null;
    }
}
