package cn.com.duiba.tuia.ecb.center.mystery.dto;

import org.apache.commons.collections.MapUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName MysteryUserInfoDTO
 * @Description
 * @Author zaizai
 * @Date 2021/5/8 11:01 上午
 */
public class MysteryUserInfoDTO implements Serializable {

    private static final long serialVersionUID = -375596667370961457L;

    /**
     * 用户id
     */
    private Long baseUserId;

    /**
     * 参与次数
     */
    private Integer joinTimes;

    /**
     * 获得的卡片
     */
    private Map<Integer, Integer> cards;

    /**
     * 是否已经获得了额外次数
     */
    private Boolean receiveExtraTimes;

    /**
     * 获奖插件信息
     */
    private MysteryPluginDTO mysteryPlugin;

    /**
     * 当前状态 0 未集齐 1已集齐 2已领取
     */
    private Integer currentStatus;

    /**
     * 剩余次数
     */
    private Integer remainTimes;

    /**
     * 当前获取的卡片id
     */
    private Integer currentCardId;

    /**
     * 额外次数
     */
    private Integer extraTimes;

    public Long getBaseUserId() {
        return baseUserId;
    }

    public void setBaseUserId(Long baseUserId) {
        this.baseUserId = baseUserId;
    }

    public Integer getJoinTimes() {
        return joinTimes;
    }

    public void setJoinTimes(Integer joinTimes) {
        this.joinTimes = joinTimes;
    }

    public Map<Integer, Integer> getCards() {
        return cards;
    }

    public void setCards(Map<Integer, Integer> cards) {
        this.cards = cards;
    }

    public Boolean getReceiveExtraTimes() {
        return receiveExtraTimes;
    }

    public void setReceiveExtraTimes(Boolean receiveExtraTimes) {
        this.receiveExtraTimes = receiveExtraTimes;
    }

    public MysteryPluginDTO getMysteryPlugin() {
        return mysteryPlugin;
    }

    public void setMysteryPlugin(MysteryPluginDTO mysteryPlugin) {
        this.mysteryPlugin = mysteryPlugin;
    }

    public Integer getCurrentStatus() {
        return currentStatus;
    }

    public void setCurrentStatus(Integer currentStatus) {
        this.currentStatus = currentStatus;
    }

    public Integer getRemainTimes() {
        return remainTimes;
    }

    public void setRemainTimes(Integer remainTimes) {
        this.remainTimes = remainTimes;
    }

    public Integer getCurrentCardId() {
        return currentCardId;
    }

    public void setCurrentCardId(Integer currentCardId) {
        this.currentCardId = currentCardId;
    }

    public Integer getExtraTimes() {
        return extraTimes;
    }

    public void setExtraTimes(Integer extraTimes) {
        this.extraTimes = extraTimes;
    }

    public void buildUserHaveCards(Integer cardId) {
        if (MapUtils.isEmpty(this.cards)) {
            this.cards = new HashMap<>();
        }
        Integer num = this.cards.get(cardId);
        if (num == null) {
            this.cards.put(cardId, 1);
        } else {
            this.cards.put(cardId, num + 1);
        }
    }

    public void resetCards() {
        if (MapUtils.isEmpty(this.cards)) {
            return;
        }
        for (Integer cardId : this.cards.keySet()) {
            Integer num = this.cards.get(cardId);
            if (num <= 0) {
                continue;
            }
            this.cards.put(cardId, num - 1);
        }
    }
}
