package cn.com.duiba.tuia.ecb.center.happy.enums;

/**
 * @author: zdw
 * @Date: 202q/8/02 2:14 下午
 * @Description: 道具类型
 */
public enum HappyClearMissionTypeEnum {

    DAILY(1, "每日任务"),
    PERIOD(2, "周期任务"),
    NEW_USER(3, "新人任务");


    HappyClearMissionTypeEnum(Integer type, String message) {
        this.type = type;
        this.message = message;
    }

    private Integer type;

    private String message;


    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static HappyClearMissionTypeEnum of(Integer type) {
        for (HappyClearMissionTypeEnum propTypeEnum : HappyClearMissionTypeEnum.values()) {
            if (propTypeEnum.getType().equals(type)) {
                return propTypeEnum;
            }
        }
        return null;
    }
}
