package cn.com.duiba.tuia.ecb.center.mineral.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mineral.rsp.MineralUserInfoRsp;

/**
 * @ClassName RemoteMineralService
 * @Description
 * @Author Zaizai
 * @Date 2021/1/6 4:34 下午
 **/
@AdvancedFeignClient
public interface RemoteMineralService {

    /**
     * 获取用户信息
     * @param consumerId
     * @return
     */
    MineralUserInfoRsp getUserInfo(Long consumerId) throws BizException;

    /**
     * 初始化用户信息
     * @param consumerId
     * @return
     */
    MineralUserInfoRsp init(Long consumerId) throws BizException;

    /**
     * 关卡晋升
     * @param consumerId
     * @param stage
     * @return
     */
    MineralUserInfoRsp promotion(Long consumerId, Integer stage) throws BizException;

    /**
     * 获取额外次数
     * @param consumerId
     * @return
     */
    MineralUserInfoRsp getExtraTimes(Long consumerId) throws BizException;

    /**
     * 尝试获取资格
     * @param consumerId
     * @param appId
     * @param activityId
     * @return
     */
    Boolean tryGetQualifications(Long consumerId, Long appId, Long activityId) throws BizException;

}
