package cn.com.duiba.tuia.ecb.center.video.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author huangruodan
 * @version 创建时间：2020/4/10 2:27 下午
 */
public enum VideoOsType {

    Android(1, "android"),
    iOS(2, "ios"),
    iPad(2, "ipad"),
    other(3, "other");

    private Integer type;

    private String desc;

    private static final Map<String, VideoOsType> osMap = Maps.newHashMap();
    static {
        osMap.put(Android.desc, Android);
        osMap.put(iOS.desc, iOS);
    }
    VideoOsType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static VideoOsType getByDesc(String desc) {
        return osMap.get(desc);
    }
}
