package cn.com.duiba.tuia.engine.billing.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

public class AsynReqDto implements Serializable {

    private static final long serialVersionUID = -2046554581114642434L;

    /** 请求任务类型 */
    private String reqType;
    /** 广告id */
    private Long   advertId;
    /** 涉及的广告订单id */
    private Long   advertOrderId;
    /** 请求任务时间 */
    private String reqTime;
    /** 发生该请求任务的appid */
    private Long   appId;
    /** 特指用于计费时计费订单id */
    private Long   chargeOrderId;
    /** 分时段投放数量记录Id */
    private Long   periodId;
    /** 广告位Id */
    private Long   slotId;
    /** 兑换项Id */
    private Long   duibaItemId;

    /** 广告出价（分）*/
    private Long fee;
    /**广告配置包id*/
    private Long advertPackageId;
    /**投放时段*/
    private Period period;

    /**
     * 折扣率 给计算媒体打折使用
     */
    private Double discountRate;
    /** 活动类型：0-互动广告，1-展示广告 */
    private Integer activityType;

    /** 转化类型*/
    private Integer cvrType;

    /** 与流量命中的人群定向标签*/
    private String hitUserInterest;

    public String getHitUserInterest() {
        return hitUserInterest;
    }

    public void setHitUserInterest(String hitUserInterest) {
        this.hitUserInterest = hitUserInterest;
    }

    public Integer getCvrType() {
        return cvrType;
    }

    public void setCvrType(Integer cvrType) {
        this.cvrType = cvrType;
    }

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    /**
     * Constructor
     */
    public AsynReqDto() {
        //
    }

    /**
     * Constructor
     *
     * @param reqType
     * @param advertId
     * @param appId
     * @param reqTime
     * @param itemId
     */
    public AsynReqDto(String reqType, Long advertId, Long appId, String reqTime, Long itemId) {
        this.reqType = reqType;
        this.advertId = advertId;
        this.appId = appId;
        this.reqTime = reqTime;
        this.duibaItemId = itemId;
    }

    /**
     * Constructor
     *
     * @param reqType
     * @param advertId
     * @param appId
     * @param reqTime
     * @param periodId
     * @param itemId
     */
    public AsynReqDto(String reqType, Long advertId, Long appId, String reqTime, Long periodId, Long itemId) {
        this.reqType = reqType;
        this.advertId = advertId;
        this.appId = appId;
        this.reqTime = reqTime;
        this.periodId = periodId;
        this.duibaItemId = itemId;
    }

    /**
     * Constructor
     *
     * @param reqType
     * @param advertId
     * @param appId
     * @param advertOrderId
     * @param reqTime
     * @param itemId
     */
    public AsynReqDto(String reqType, Long advertId, Long appId, Long advertOrderId, String reqTime, Long itemId) {
        this.reqType = reqType;
        this.advertId = advertId;
        this.appId = appId;
        this.advertOrderId = advertOrderId;
        this.reqTime = reqTime;
        this.duibaItemId = itemId;
    }

    public AsynReqDto(String reqType, Long advertId, Long appId, Long advertOrderId, String reqTime, Long itemId,Long fee) {
        this.reqType = reqType;
        this.advertId = advertId;
        this.appId = appId;
        this.advertOrderId = advertOrderId;
        this.reqTime = reqTime;
        this.duibaItemId = itemId;
        this.fee = fee;
    }

    /**
     * Constructor
     *
     * @param reqType
     * @param advertId
     * @param appId
     * @param advertOrderId
     * @param chargeOrderId
     * @param reqTime
     * @param itemId
     */
    public AsynReqDto(String reqType, Long advertId, Long appId, Long advertOrderId, Long chargeOrderId, String reqTime,
                   Long itemId) {
        this.reqType = reqType;
        this.advertId = advertId;
        this.appId = appId;
        this.advertOrderId = advertOrderId;
        this.chargeOrderId = chargeOrderId;
        this.reqTime = reqTime;
        this.duibaItemId = itemId;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getReqType() {
        return reqType;
    }

    public void setReqType(String reqType) {
        this.reqType = reqType;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getAdvertOrderId() {
        return advertOrderId;
    }

    public void setAdvertOrderId(Long advertOrderId) {
        this.advertOrderId = advertOrderId;
    }

    public String getReqTime() {
        return reqTime;
    }

    public void setReqTime(String reqTime) {
        this.reqTime = reqTime;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getChargeOrderId() {
        return chargeOrderId;
    }

    public void setChargeOrderId(Long chargeOrderId) {
        this.chargeOrderId = chargeOrderId;
    }

    public Long getPeriodId() {
        return periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getDuibaItemId() {
        return duibaItemId;
    }

    public void setDuibaItemId(Long duibaItemId) {
        this.duibaItemId = duibaItemId;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Long getAdvertPackageId() {
        return advertPackageId;
    }

    public void setAdvertPackageId(Long advertPackageId) {
        this.advertPackageId = advertPackageId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }


    public Period getPeriod() {
        return period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Double getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }
}
