/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.domain.enums;

import cn.com.duiba.tuia.domain.model.LogicDataCaler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum LowNeedsCalTypeEnum {
    BIGGER(">", (data, threshold) -> data.compareTo(threshold) > 0),
    SMALLER("<", (data, threshold) -> data.compareTo(threshold) < 0);

    private static final Map<String, LogicDataCaler> logicDataCalerMap;
    private String calName;
    private LogicDataCaler logicDataCaler;

    public static LogicDataCaler getLogicDataCalerByName(String name) {
        if (null == name) {
            return null;
        }
        return logicDataCalerMap.get(name);
    }

    private LowNeedsCalTypeEnum(String calName, LogicDataCaler logicDataCaler) {
        this.calName = calName;
        this.logicDataCaler = logicDataCaler;
    }

    public String getCalName() {
        return this.calName;
    }

    public void setCalName(String calName) {
        this.calName = calName;
    }

    public LogicDataCaler getLogicDataCaler() {
        return this.logicDataCaler;
    }

    public void setLogicDataCaler(LogicDataCaler logicDataCaler) {
        this.logicDataCaler = logicDataCaler;
    }

    static {
        logicDataCalerMap = new ConcurrentHashMap<String, LogicDataCaler>();
        for (LowNeedsCalTypeEnum value : LowNeedsCalTypeEnum.values()) {
            logicDataCalerMap.put(value.getCalName(), value.getLogicDataCaler());
        }
    }
}

