/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.domain.enums;

import cn.com.duiba.tuia.domain.model.ResourceDataGetter;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum LowNeedsDataTypeEnum {
    EXPOSURE("exposure", data -> new BigDecimal(data.getExposurePv())),
    CTR("ctr", data -> new BigDecimal(data.getCtr())),
    CVR("cvr", data -> new BigDecimal(data.getCvr()));

    private static final Map<String, ResourceDataGetter> resourceDataGetterMap;
    private String dataName;
    private ResourceDataGetter dataGetter;

    public static ResourceDataGetter getResourceDataGetterByName(String name) {
        if (null == name) {
            return null;
        }
        return resourceDataGetterMap.get(name);
    }

    private LowNeedsDataTypeEnum(String dataName, ResourceDataGetter dataGetter) {
        this.dataName = dataName;
        this.dataGetter = dataGetter;
    }

    public String getDataName() {
        return this.dataName;
    }

    public void setDataName(String dataName) {
        this.dataName = dataName;
    }

    public ResourceDataGetter getDataGetter() {
        return this.dataGetter;
    }

    public void setDataGetter(ResourceDataGetter dataGetter) {
        this.dataGetter = dataGetter;
    }

    static {
        resourceDataGetterMap = new ConcurrentHashMap<String, ResourceDataGetter>();
        for (LowNeedsDataTypeEnum value : LowNeedsDataTypeEnum.values()) {
            resourceDataGetterMap.put(value.getDataName(), value.getDataGetter());
        }
    }
}

