/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.domain.vo;

import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.domain.vo.SimilarAdvertLogVO;
import cn.com.tuia.advert.enums.ChargeTypeEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.util.CollectionUtils;

public class AdvertFilterVO {
    public static final Long NEW_APP_TEST_MIN_FEE = 10L;
    public static final Long NEW_APP_TEST_MAX_FEE = 40L;
    private Long advertId;
    private Long accountId;
    private String matchTags;
    private Integer order;
    private List<SimilarAdvertLogVO> similarAdvertLogList;
    private int improveBiddingStatus;
    private AdvertPriceVO minFee10PriceVO;
    private Long minFee10Price;
    private String newTradeName;
    private String resourceTag;
    private Set<String> shieldMaterialTags;
    private List<Long> newAppNotTestPackageIds;
    private Map<Long, Integer> targetedAppMap;
    private BigDecimal advertWeight;
    private SortedSet<AdvertPriceVO> advertPriceVOSortedSet;
    private SortedSet<AdvertPriceVO> manualAdvertSet;
    private SortedSet<AdvertPriceVO> autoModelAdvertSet;
    private SortedSet<AdvertPriceVO> optimalModelAdvertSet;

    public Set<String> getShieldMaterialTags() {
        return this.shieldMaterialTags;
    }

    public void setShieldMaterialTags(Set<String> shieldMaterialTags) {
        this.shieldMaterialTags = shieldMaterialTags;
    }

    public String getResourceTag() {
        return this.resourceTag;
    }

    public void setResourceTag(String resourceTag) {
        this.resourceTag = resourceTag;
    }

    public List<Long> getNewAppNotTestPackageIds() {
        return this.newAppNotTestPackageIds;
    }

    public void setNewAppNotTestPackageIds(List<Long> newAppNotTestPackageIds) {
        this.newAppNotTestPackageIds = newAppNotTestPackageIds;
    }

    public String getNewTradeName() {
        return this.newTradeName;
    }

    public void setNewTradeName(String newTradeName) {
        this.newTradeName = newTradeName;
    }

    public Long getMinFee10Price() {
        return this.minFee10Price;
    }

    public void setMinFee10Price(Long minFee10Price) {
        this.minFee10Price = minFee10Price;
    }

    public AdvertPriceVO getMinFee10PriceVO() {
        return this.minFee10PriceVO;
    }

    public boolean setMinFee10PriceVO(Map<Long, Integer> targetedAppMap, Integer appSize) {
        List list = this.advertPriceVOSortedSet.stream().filter(af -> ChargeTypeEnum.TYPE_CPA.getCode() != af.getChargeType().intValue() && af.getFee() >= NEW_APP_TEST_MIN_FEE && !this.newAppNotTestPackageIds.contains(-1L) && !this.newAppNotTestPackageIds.contains(af.getOriginalOrientationId())).filter(temp -> {
            Integer size = (Integer)targetedAppMap.get(temp.getAdvertOrientationPackageId());
            return size != null && size > appSize;
        }).sorted(Comparator.comparing(AdvertPriceVO::getFee)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            this.minFee10PriceVO = null;
        } else {
            this.minFee10PriceVO = (AdvertPriceVO)list.get(0);
            this.setMinFee10Price(((AdvertPriceVO)list.get(0)).getFee());
        }
        return true;
    }

    public List<SimilarAdvertLogVO> getSimilarAdvertLogList() {
        return this.similarAdvertLogList;
    }

    public void setSimilarAdvertLogList(List<SimilarAdvertLogVO> similarAdvertLogList) {
        this.similarAdvertLogList = similarAdvertLogList;
    }

    public int getImproveBiddingStatus() {
        return this.improveBiddingStatus;
    }

    public void setImproveBiddingStatus(int improveBiddingStatus) {
        this.improveBiddingStatus = improveBiddingStatus;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public AdvertFilterVO() {
    }

    public BigDecimal getAdvertWeight() {
        return this.advertWeight;
    }

    public void setAdvertWeight(BigDecimal advertWeight) {
        this.advertWeight = advertWeight;
    }

    public AdvertFilterVO(Long advertId) {
        this.advertId = advertId;
    }

    public Long getAdvertId() {
        return this.advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getMatchTags() {
        return this.matchTags;
    }

    public void setMatchTags(String matchTags) {
        this.matchTags = matchTags;
    }

    public Map<Long, Integer> getTargetedAppMap() {
        return this.targetedAppMap;
    }

    public void setTargetedAppMap(Map<Long, Integer> targetedAppMap) {
        this.targetedAppMap = targetedAppMap;
    }

    public SortedSet<AdvertPriceVO> getAdvertPriceVOSortedSet() {
        return this.advertPriceVOSortedSet;
    }

    public void setAdvertPriceVOSortedSet(SortedSet<AdvertPriceVO> advertPriceVOSortedSet) {
        this.advertPriceVOSortedSet = advertPriceVOSortedSet;
    }

    public SortedSet<AdvertPriceVO> getManualAdvertSet() {
        return this.manualAdvertSet;
    }

    public void setManualAdvertSet(SortedSet<AdvertPriceVO> manualAdvertSet) {
        this.manualAdvertSet = manualAdvertSet;
    }

    public SortedSet<AdvertPriceVO> getAutoModelAdvertSet() {
        return this.autoModelAdvertSet;
    }

    public void setAutoModelAdvertSet(SortedSet<AdvertPriceVO> autoModelAdvertSet) {
        this.autoModelAdvertSet = autoModelAdvertSet;
    }

    public SortedSet<AdvertPriceVO> getOptimalModelAdvertSet() {
        return this.optimalModelAdvertSet;
    }

    public void setOptimalModelAdvertSet(SortedSet<AdvertPriceVO> optimalModelAdvertSet) {
        this.optimalModelAdvertSet = optimalModelAdvertSet;
    }

    private AdvertPriceVO getRandomCpcMaxFeeAdvert(SortedSet<AdvertPriceVO> priceList) {
        Map<Long, List<AdvertPriceVO>> feeMap = priceList.stream().collect(Collectors.groupingBy(AdvertPriceVO::getFee));
        AdvertPriceVO maxFeeAdvert = priceList.last();
        Long maxFee = maxFeeAdvert.getFee();
        List<AdvertPriceVO> maxFeeList = feeMap.get(maxFee);
        Random random = new Random();
        int randomNum = random.nextInt(maxFeeList.size());
        return maxFeeList.get(randomNum);
    }

    private AdvertPriceVO getRandomMaxConvertCostAdvert(SortedSet<AdvertPriceVO> priceList) {
        Map<Long, List<AdvertPriceVO>> feeMap = priceList.stream().collect(Collectors.groupingBy(AdvertPriceVO::getConvertCost));
        AdvertPriceVO maxFeeAdvert = priceList.last();
        Long maxFee = maxFeeAdvert.getConvertCost();
        List<AdvertPriceVO> maxFeeList = feeMap.get(maxFee);
        Random random = new Random();
        int randomNum = random.nextInt(maxFeeList.size());
        return maxFeeList.get(randomNum);
    }

    public AdvertPriceVO getManualMaxFeeAdvert() {
        if (CollectionUtils.isEmpty(this.manualAdvertSet)) {
            return null;
        }
        return this.getRandomCpcMaxFeeAdvert(this.manualAdvertSet);
    }

    public List<AdvertPriceVO> getMaxFeeAdvertListForNezha(Integer flowBiddingType) {
        if (flowBiddingType == 1) {
            return this.getMaxFeeListCostPriority();
        }
        return this.getMaxFeeListPriorityBidding();
    }

    private List<AdvertPriceVO> getMaxFeeListCostPriority() {
        ArrayList result = Lists.newArrayList();
        if (!this.autoModelAdvertSet.isEmpty()) {
            result.addAll(this.autoModelAdvertSet);
        }
        if (!CollectionUtils.isEmpty(this.optimalModelAdvertSet)) {
            this.getRandomMaxConvertCostAdvertBySubtype(result);
        } else if (!CollectionUtils.isEmpty(this.manualAdvertSet)) {
            result.add(this.getRandomCpcMaxFeeAdvert(this.manualAdvertSet));
        }
        return result;
    }

    private List<AdvertPriceVO> getMaxFeeListPriorityBidding() {
        ArrayList result = Lists.newArrayList();
        if (!this.autoModelAdvertSet.isEmpty()) {
            result.addAll(this.autoModelAdvertSet);
        }
        if (!CollectionUtils.isEmpty(this.optimalModelAdvertSet)) {
            this.getOptimalModelMaxFeeAdvertBySubtype(result);
        }
        if (!CollectionUtils.isEmpty(this.manualAdvertSet)) {
            result.add(this.getRandomCpcMaxFeeAdvert(this.manualAdvertSet));
        }
        return result;
    }

    private void getRandomMaxConvertCostAdvertBySubtype(List<AdvertPriceVO> result) {
        Map<Integer, AdvertPriceVO> subtypeMap = this.optimalModelAdvertSet.stream().collect(Collectors.groupingBy(AdvertPriceVO::getSubtype, Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), this::getRandomMaxConvertCostAdvert)));
        result.addAll(subtypeMap.values());
    }

    private List<AdvertPriceVO> getOptimalModelMaxFeeAdvert(SortedSet<AdvertPriceVO> optimalModelAdvertSet) {
        TreeSet cpcList = Sets.newTreeSet();
        TreeSet ocpcList = Sets.newTreeSet();
        for (AdvertPriceVO advertPriceVO : optimalModelAdvertSet) {
            if (advertPriceVO.getChargeType().intValue() == ChargeTypeEnum.TYPE_CPC.getCode()) {
                cpcList.add(advertPriceVO);
                continue;
            }
            ocpcList.add(advertPriceVO);
        }
        ArrayList result = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)cpcList)) {
            result.add(this.getRandomCpcMaxFeeAdvert(cpcList));
        }
        if (!CollectionUtils.isEmpty((Collection)ocpcList)) {
            result.add(this.getRandomMaxConvertCostAdvert(ocpcList));
        }
        return result;
    }

    private void getOptimalModelMaxFeeAdvertBySubtype(List<AdvertPriceVO> result) {
        Map<Integer, List> subtypeMap = this.optimalModelAdvertSet.stream().collect(Collectors.groupingBy(AdvertPriceVO::getSubtype, Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), this::getOptimalModelMaxFeeAdvert)));
        List collect = subtypeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        result.addAll(collect);
    }

    public List<AdvertPriceVO> getMaxFeeAdvertListForNezhaInExpand(Integer flowBiddingType) {
        if (flowBiddingType == 1) {
            return this.getMaxFeeListCostPriorityInExpand();
        }
        return this.getMaxFeeListPriorityBiddingInExpand();
    }

    private List<AdvertPriceVO> getMaxFeeListCostPriorityInExpand() {
        ArrayList result = Lists.newArrayList();
        if (!this.autoModelAdvertSet.isEmpty()) {
            result.addAll(this.autoModelAdvertSet);
        }
        if (!CollectionUtils.isEmpty(this.optimalModelAdvertSet)) {
            this.getRandomMaxConvertCostAdvertBySubtypeInExpand(result);
        } else if (!CollectionUtils.isEmpty(this.manualAdvertSet)) {
            result.add(this.getRandomCpcMaxFeeAdvert(this.manualAdvertSet));
        }
        return result;
    }

    private List<AdvertPriceVO> getMaxFeeListPriorityBiddingInExpand() {
        ArrayList result = Lists.newArrayList();
        if (!this.autoModelAdvertSet.isEmpty()) {
            result.addAll(this.autoModelAdvertSet);
        }
        if (!CollectionUtils.isEmpty(this.optimalModelAdvertSet)) {
            this.getOptimalModelMaxFeeAdvertBySubtypeInExpand(result);
        }
        if (!CollectionUtils.isEmpty(this.manualAdvertSet)) {
            result.add(this.getRandomCpcMaxFeeAdvert(this.manualAdvertSet));
        }
        return result;
    }

    private void getRandomMaxConvertCostAdvertBySubtypeInExpand(List<AdvertPriceVO> result) {
        Map<Integer, List> subtypeMap = this.optimalModelAdvertSet.stream().collect(Collectors.groupingBy(AdvertPriceVO::getSubtype, Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), this::getRandomMaxConvertCostAdvertInExpand)));
        List collect = subtypeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        result.addAll(collect);
    }

    private void getOptimalModelMaxFeeAdvertBySubtypeInExpand(List<AdvertPriceVO> result) {
        Map<Integer, List> subtypeMap = this.optimalModelAdvertSet.stream().collect(Collectors.groupingBy(AdvertPriceVO::getSubtype, Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), this::getOptimalModelMaxFeeAdvertInExpand)));
        List collect = subtypeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        result.addAll(collect);
    }

    private List<AdvertPriceVO> getRandomMaxConvertCostAdvertInExpand(SortedSet<AdvertPriceVO> priceList) {
        TreeSet cpcList = Sets.newTreeSet();
        TreeSet ocpcList = Sets.newTreeSet();
        for (AdvertPriceVO advertPriceVO : priceList) {
            if (advertPriceVO.getChargeType().intValue() == ChargeTypeEnum.TYPE_CPC.getCode()) {
                cpcList.add(advertPriceVO);
                continue;
            }
            ocpcList.add(advertPriceVO);
        }
        ArrayList result = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)cpcList)) {
            result.add(this.getRandomMaxConvertCostAdvert(cpcList));
        }
        if (!CollectionUtils.isEmpty((Collection)ocpcList)) {
            result.addAll(ocpcList);
        }
        return result;
    }

    private List<AdvertPriceVO> getOptimalModelMaxFeeAdvertInExpand(SortedSet<AdvertPriceVO> optimalModelAdvertSet) {
        TreeSet cpcList = Sets.newTreeSet();
        TreeSet ocpcList = Sets.newTreeSet();
        for (AdvertPriceVO advertPriceVO : optimalModelAdvertSet) {
            if (advertPriceVO.getChargeType().intValue() == ChargeTypeEnum.TYPE_CPC.getCode()) {
                cpcList.add(advertPriceVO);
                continue;
            }
            ocpcList.add(advertPriceVO);
        }
        ArrayList result = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)cpcList)) {
            result.add(this.getRandomCpcMaxFeeAdvert(cpcList));
        }
        if (!CollectionUtils.isEmpty((Collection)ocpcList)) {
            result.addAll(ocpcList);
        }
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

