/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.domain.vo;

import cn.com.duiba.tuia.domain.dataobject.DmpAdvertDO;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class PartAdvertFilterVO {
    private Map<Long, AdvertPriceVO> advertPriceVOMap;
    private Map<Long, AdvertPriceVO> manualAdvertMap;
    private Map<Long, AdvertPriceVO> autoModelAdvertMap;
    private Map<Long, AdvertPriceVO> optimalModelAdvertMap;

    public PartAdvertFilterVO(AdvertFilterVO value) {
        this.advertPriceVOMap = this.convertSetToMap(value.getAdvertPriceVOSortedSet());
        this.manualAdvertMap = this.convertSetToMap(value.getManualAdvertSet());
        this.autoModelAdvertMap = this.convertSetToMap(value.getAutoModelAdvertSet());
        this.optimalModelAdvertMap = this.convertSetToMap(value.getOptimalModelAdvertSet());
    }

    private Map<Long, AdvertPriceVO> convertSetToMap(SortedSet<AdvertPriceVO> advertPriceVOSortedSet) {
        HashMap<Long, AdvertPriceVO> rtnMap = new HashMap<Long, AdvertPriceVO>();
        Optional.ofNullable(advertPriceVOSortedSet).ifPresent(sortedSet -> advertPriceVOSortedSet.forEach(vo -> rtnMap.put(vo.getAdvertOrientationPackageId(), (AdvertPriceVO)vo)));
        return rtnMap;
    }

    public Map<Long, AdvertPriceVO> getAdvertPriceVOMap() {
        return this.advertPriceVOMap;
    }

    public void setAdvertPriceVOMap(Map<Long, AdvertPriceVO> advertPriceVOMap) {
        this.advertPriceVOMap = advertPriceVOMap;
    }

    public Map<Long, AdvertPriceVO> getManualAdvertMap() {
        return this.manualAdvertMap;
    }

    public void setManualAdvertMap(Map<Long, AdvertPriceVO> manualAdvertMap) {
        this.manualAdvertMap = manualAdvertMap;
    }

    public Map<Long, AdvertPriceVO> getAutoModelAdvertMap() {
        return this.autoModelAdvertMap;
    }

    public void setAutoModelAdvertMap(Map<Long, AdvertPriceVO> autoModelAdvertMap) {
        this.autoModelAdvertMap = autoModelAdvertMap;
    }

    public Map<Long, AdvertPriceVO> getOptimalModelAdvertMap() {
        return this.optimalModelAdvertMap;
    }

    public void setOptimalModelAdvertMap(Map<Long, AdvertPriceVO> optimalModelAdvertMap) {
        this.optimalModelAdvertMap = optimalModelAdvertMap;
    }

    public void remove(List<DmpAdvertDO> value) {
        if (null == value || value.isEmpty()) {
            return;
        }
        for (DmpAdvertDO dmpAdvertDO : value) {
            Optional.ofNullable(dmpAdvertDO.getOrientId()).ifPresent(orientId -> {
                this.advertPriceVOMap.remove(orientId);
                this.manualAdvertMap.remove(orientId);
                this.autoModelAdvertMap.remove(orientId);
                this.optimalModelAdvertMap.remove(orientId);
            });
        }
    }

    public void remove(Long orientId) {
        if (null == orientId) {
            return;
        }
        this.advertPriceVOMap.remove(orientId);
        this.manualAdvertMap.remove(orientId);
        this.autoModelAdvertMap.remove(orientId);
        this.optimalModelAdvertMap.remove(orientId);
    }

    public Boolean containsOrient(DmpAdvertDO x) {
        if (null == x || null == x.getOrientId()) {
            return false;
        }
        return this.advertPriceVOMap.containsKey(x.getOrientId());
    }

    public void writeBackToAdvertFilterVO(AdvertFilterVO advertFilterVO) {
        advertFilterVO.setAdvertPriceVOSortedSet(new TreeSet<AdvertPriceVO>(this.advertPriceVOMap.values()));
        advertFilterVO.setManualAdvertSet(new TreeSet<AdvertPriceVO>(this.manualAdvertMap.values()));
        advertFilterVO.setAutoModelAdvertSet(new TreeSet<AdvertPriceVO>(this.autoModelAdvertMap.values()));
        advertFilterVO.setOptimalModelAdvertSet(new TreeSet<AdvertPriceVO>(this.optimalModelAdvertMap.values()));
    }

    public void removeOthers(List<DmpAdvertDO> dmpAdvertDOS) {
        List leftOrientIds = dmpAdvertDOS.stream().map(DmpAdvertDO::getOrientId).collect(Collectors.toList());
        HashSet<Long> removeSet = new HashSet<Long>(this.advertPriceVOMap.keySet());
        removeSet.removeAll(leftOrientIds);
        for (Long orientId : removeSet) {
            this.advertPriceVOMap.remove(orientId);
            this.manualAdvertMap.remove(orientId);
            this.autoModelAdvertMap.remove(orientId);
            this.optimalModelAdvertMap.remove(orientId);
        }
    }
}

