/**
 * Project Name:media-api<br>
 * File Name:ActivityDataDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年10月18日下午8:47:22<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: ActivityDataDto <br/>
 * Function: 活动统计数据. <br/>
 * date: 2016年10月18日 下午8:47:22 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class BaseActivityDataDto {

    /** 每日曝光数. */
    private long  exposureCount;

    /** 每日点击数. */
    private long  clickCount;

    /** 曝光点击率=点击量/曝光量. */
    private Float exposureCTR;

    /** 活动UV. */
    private long  activityUv;

    /** 活动参与次数. */
    private long  involveCounts;

    /** 活动参与人数. */
    private long  participantCounts;

    /** 人均参与次数=活动参与次数/活动参与人数. */
    private Long  perParticipate;

    /** 参与率 =活动参人数/活动UV. */
    private Float rate;

    /** 活动发券. */
    private long  launchAdvertCount;

    /** spm=活动发券数量/活动曝光*1000. */
    private Long  spm;

    /** 发券成功率=活动发券量/请求广告次数. */
    private Float launchRate;

    /** 广告点击量. */
    private long  clickAdvertCount;

    /** 每日消费(分). */
    private long  consumeTotal;

    /** eCPM(活动每千次展示获得的广告收入)=每日消费/(活动每日曝光数*1000). */
    private Long  eCPM;

    public long getExposureCount() {
        return exposureCount;
    }

    public void setExposureCount(long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public long getClickCount() {
        return clickCount;
    }

    public void setClickCount(long clickCount) {
        this.clickCount = clickCount;
    }

    public Float getExposureCTR() {
        return exposureCTR;
    }

    public void setExposureCTR(Float exposureCTR) {
        this.exposureCTR = exposureCTR;
    }

    public long getActivityUv() {
        return activityUv;
    }

    public void setActivityUv(long activityUv) {
        this.activityUv = activityUv;
    }

    public long getInvolveCounts() {
        return involveCounts;
    }

    public void setInvolveCounts(long involveCounts) {
        this.involveCounts = involveCounts;
    }

    public long getParticipantCounts() {
        return participantCounts;
    }

    public void setParticipantCounts(long participantCounts) {
        this.participantCounts = participantCounts;
    }

    public Long getPerParticipate() {
        return perParticipate;
    }

    public void setPerParticipate(Long perParticipate) {
        this.perParticipate = perParticipate;
    }

    public Float getRate() {
        return rate;
    }

    public void setRate(Float rate) {
        this.rate = rate;
    }

    public long getLaunchAdvertCount() {
        return launchAdvertCount;
    }

    public void setLaunchAdvertCount(long launchAdvertCount) {
        this.launchAdvertCount = launchAdvertCount;
    }

    public Long getSpm() {
        return spm;
    }

    public void setSpm(Long spm) {
        this.spm = spm;
    }

    public Float getLaunchRate() {
        return launchRate;
    }

    public void setLaunchRate(Float launchRate) {
        this.launchRate = launchRate;
    }

    public long getClickAdvertCount() {
        return clickAdvertCount;
    }

    public void setClickAdvertCount(long clickAdvertCount) {
        this.clickAdvertCount = clickAdvertCount;
    }

    public long getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    public Long geteCPM() {
        return eCPM;
    }

    public void seteCPM(Long eCPM) {
        this.eCPM = eCPM;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
