/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDto.java<br/>
 * Package Name:cn.com.duiba.tuia.media.domain<br/>
 * Date:2016年9月26日下午5:05:11<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告位Dto <br/>
 * Date: 2016年9月26日 下午5:05:11 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class SlotDto extends BaseDto {

    private static final long serialVersionUID                = 8911023809144330642L;

    /** 广告位类型 0-插屏. */
    public static final int   ADSENSE_TYPE_PLAQUE             = 0;
    /** 广告位类型 1-横幅. */
    public static final int   ADSENSE_TYPE_STREAMER_BANNER    = 1;
    /** 广告位类型 2-信息流. */
    public static final int   ADSENSE_TYPE_INFORMATION_STREAM = 2;
    /** 广告位类型 3-banner. */
    public static final int   ADSENSE_TYPE_BANNER             = 3;
    /** 广告位类型 4-浮标. */
    public static final int   ADSENSE_TYPE_BUOY               = 4;
    /** 广告位类型 5-应用墙. */
    public static final int   ADSENSE_TYPE_APP_WALL           = 5;

    /** 主图尺寸 0-600*300. */
    public static final int   PICTURE_SIZE_600_300            = 0;
    /** 主图尺寸 1-600*500. */
    public static final int   PICTURE_SIZE_600_500            = 1;
    /** 主图尺寸 2-640*270. */
    public static final int   PICTURE_SIZE_640_270            = 2;
    /** 主图尺寸 3-960*640. */
    public static final int   PICTURE_SIZE_960_640            = 3;
    /** 主图尺寸 4-800*120. */
    public static final int   PICTURE_SIZE_800_120            = 4;

    /** 组合元素 0：标题. */
    public static final int   ELEMENT_TYPE_TITLE              = 0;
    /** 组合元素 1：描述. */
    public static final int   ELEMENT_TYPE_DESCRIBE           = 1;
    /** 组合元素 2：图标. */
    public static final int   ELEMENT_TYPE_ICON               = 2;
    /** 组合元素 3：大图. */
    public static final int   ELEMENT_TYPE_BIG_IMG            = 3;

    /** 开通状态:0-待审核. */
    public static final int   CHECK_STATUS_CHECKING           = 0;

    /** 开通状态:2-审核通过. */
    public static final int   CHECK_STATUS_PASS               = 1;
    
    /** 开通状态:1-审核拒绝. */
    public static final int   CHECK_STATUS_FAIL               = 2;

    /** 广告位状态:0-关闭. */
    public static final int   ENABLE_STATUS_CLOSE             = 0;
    /** 广告位状态:1-开启. */
    public static final int   ENABLE_STATUS_OPEN              = 1;

    /** 媒体ID. */
    private Long              appId;

    /** 媒体用户ID. */
    private Long              mediaId;

    /** 广告位名称. */
    private String            slotName;

    /** 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙. */
    private Integer           slotType;

    /** 审核状态:0-待审核;1-审核拒绝;2-审核通过. */
    private Integer           checkStatus;

    /** 广告位状态:0-关闭;1-开启. */
    private Integer           enableStatus;

    /** 主图尺寸 0-600*300 1-600*500 2-640*270 3-960*640 4-800*120. */
    private Integer           pictureSize;

    /** 组合元素(0：标题, 1：描述, 2：图标, 3：大图:) 可多选中间用逗号(',')隔开. */
    private String            elementType;

    /** 屏蔽策略ID. */
    private Long              strategyId;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Integer getSlotType() {
        return slotType;
    }

    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getPictureSize() {
        return pictureSize;
    }

    public void setPictureSize(Integer pictureSize) {
        this.pictureSize = pictureSize;
    }

    /**
     * elementType.
     *
     * @return the elementType
     * @since JDK 1.6
     */
    public String getElementType() {
        return elementType;
    }

    /**
     * elementType.
     *
     * @param elementType the elementType to set
     * @since JDK 1.6
     */
    public void setElementType(String elementType) {
        this.elementType = elementType;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
