package cn.com.duiba.tuia.media.api.dto.req;

import cn.com.duiba.tuia.media.api.dto.BaseQueryDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.beans.Transient;
import java.io.Serializable;
import java.util.List;

/**
 * Function: 媒体定制活动排序查询条件
 *
 * @author xuyenan
 * @createTime 2016/10/24
 */
@ApiModel
public class ReqActivitySort extends BaseQueryDto implements Serializable {

    private static final long serialVersionUID = -4243315336347406227L;

    /** 活动类型 */
    @ApiModelProperty(value = "活动类型", required = false)
    private Integer           activityType;

    /** 活动ID */
    @ApiModelProperty(value = "活动ID", required = false)
    private Long              activityId;

    /** 活动名称 */
    @ApiModelProperty(value = "活动名称", required = false)
    private String            activityName;

    /** 活动媒体ID */
    @ApiModelProperty(value = "活动媒体ID", required = false)
    private Long              activityAppId;

    /** 活动ID列表 */
    private List<Long>        activityIds;

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Long getActivityAppId() {
        return activityAppId;
    }

    public void setActivityAppId(Long activityAppId) {
        this.activityAppId = activityAppId;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }
}
