/**
 * Project Name:media-api<br>
 * File Name:ReqGetSlotsByPageDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年9月30日下午4:29:44<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import cn.com.duiba.tuia.media.api.dto.BaseQueryDto;

/**
 * ClassName: ReqGetSlotsByPageDto <br/>
 * Function: 分页查询广告位请求参数. <br/>
 * date: 2016年9月30日 下午4:29:44 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqGetSlotsByPageDto extends BaseQueryDto {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -3748108448926104043L;

    @ApiModelProperty(value = "广告位ID", required = false)
    private Long              slotId;

    @ApiModelProperty(value = "广告位名称", required = false)
    private String            slotName;

    @ApiModelProperty(value = "媒体应用ID", required = false)
    private Long              appId;

    @ApiModelProperty(value = "媒体应用名称", required = false)
    private String            appName;

    @ApiModelProperty(value = "审核状态:0-待审核;1-审核通过;2-审核拒绝", required = true)
    private Integer           checkStatus;

    @ApiModelProperty(value = "广告位类型: 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙", required = true)
    private Integer           slotType;

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * slotType.
     *
     * @return the slotType
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * slotType.
     *
     * @param slotType the slotType to set
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

}
