/**
 * Project Name:media-api<br>
 * File Name:RspSlotDetailDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto.rsp<br>
 * Date:2016年10月14日上午9:45:25<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: RspSlotDetailDto <br/>
 * date: 2016年10月14日 上午9:45:26 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class RspSlotDetailDto implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -1368433294004913036L;

    /** 广告位ID. */
    private Long              slotId;

    /** 广告位名称. */
    private String            slotName;

    /** 广告位类型. */
    private Integer           slotType;

    /** 媒体ID. */
    private Long              appId;

    /** 媒体应用名称. */
    private String            appName;

    /** 主图尺寸 0-600*300 1-600*500 2-640*270 3-960*640 4-800*120. */
    private Integer           pictureSize;

    /** 组合元素(0：标题, 1：描述, 2：图标, 3：大图:) 可多选中间用逗号(',')隔开. */
    private List<String>      elementType;

    /** 屏蔽策略ID. */
    private Long              strategyId;

    /** 屏蔽策略名称. */
    private String            strategyName;

    /** 屏蔽行业. */
    private List<String>      shieldIndustries;

    /** 屏蔽广告主. */
    private List<String>      shieldAdvertisers;

    /** The industry flag. */
    private boolean           industryFlag     = false;

    /** The advertiser flag. */
    private boolean           advertiserFlag   = false;

    /**
     * industryFlag.
     *
     * @return the industryFlag
     * @since JDK 1.6
     */
    public boolean isIndustryFlag() {
        return industryFlag;
    }

    /**
     * industryFlag.
     *
     * @param industryFlag the industryFlag to set
     * @since JDK 1.6
     */
    public void setIndustryFlag(boolean industryFlag) {
        this.industryFlag = industryFlag;
    }

    /**
     * advertiserFlag.
     *
     * @return the advertiserFlag
     * @since JDK 1.6
     */
    public boolean isAdvertiserFlag() {
        return advertiserFlag;
    }

    /**
     * advertiserFlag.
     *
     * @param advertiserFlag the advertiserFlag to set
     * @since JDK 1.6
     */
    public void setAdvertiserFlag(boolean advertiserFlag) {
        this.advertiserFlag = advertiserFlag;
    }

    /**
     * slotType.
     *
     * @return the slotType
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * slotType.
     *
     * @param slotType the slotType to set
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * pictureSize.
     *
     * @return the pictureSize
     * @since JDK 1.6
     */
    public Integer getPictureSize() {
        return pictureSize;
    }

    /**
     * pictureSize.
     *
     * @param pictureSize the pictureSize to set
     * @since JDK 1.6
     */
    public void setPictureSize(Integer pictureSize) {
        this.pictureSize = pictureSize;
    }

    /**
     * elementType.
     *
     * @return the elementType
     * @since JDK 1.6
     */
    public List<String> getElementType() {
        return elementType;
    }

    /**
     * elementType.
     *
     * @param elementType the elementType to set
     * @since JDK 1.6
     */
    public void setElementType(List<String> elementType) {
        this.elementType = elementType;
    }

    /**
     * strategyId.
     *
     * @return the strategyId
     * @since JDK 1.6
     */
    public Long getStrategyId() {
        return strategyId;
    }

    /**
     * strategyId.
     *
     * @param strategyId the strategyId to set
     * @since JDK 1.6
     */
    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    /**
     * strategyName.
     *
     * @return the strategyName
     * @since JDK 1.6
     */
    public String getStrategyName() {
        return strategyName;
    }

    /**
     * strategyName.
     *
     * @param strategyName the strategyName to set
     * @since JDK 1.6
     */
    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    /**
     * shieldIndustries.
     *
     * @return the shieldIndustries
     * @since JDK 1.6
     */
    public List<String> getShieldIndustries() {
        return shieldIndustries;
    }

    /**
     * shieldIndustries.
     *
     * @param shieldIndustries the shieldIndustries to set
     * @since JDK 1.6
     */
    public void setShieldIndustries(List<String> shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    /**
     * shieldAdvertisers.
     *
     * @return the shieldAdvertisers
     * @since JDK 1.6
     */
    public List<String> getShieldAdvertisers() {
        return shieldAdvertisers;
    }

    /**
     * shieldAdvertisers.
     *
     * @param shieldAdvertisers the shieldAdvertisers to set
     * @since JDK 1.6
     */
    public void setShieldAdvertisers(List<String> shieldAdvertisers) {
        this.shieldAdvertisers = shieldAdvertisers;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);

    }

}
