package cn.com.duiba.tuia.media.api.remoteservice;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public interface RemoteActivitySortBackendService {

    /**
     * 查询活动列表接口
     *
     * @param reqActivitySort 查询条件
     */
    DubboResult<List<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort);

    /**
     * 添加活动接口
     *
     * @param activityIds 活动ID列表
     */
    DubboResult<Boolean> addActivitySort(Long activityAppId, List<Long> activityIds);

    /**
     * 添加默认活动接口
     */
    DubboResult<Boolean> addDefaultActivitySort(Long activityAppId);

    /**
     * 移除活动接口
     *
     * @param activityAppId 媒体ID，默认活动排序媒体ID为0
     * @param activityId 活动ID
     */
    DubboResult<Boolean> removeActivity(Long activityAppId, Long activityId);

    /**
     * 排序接口
     *
     * @param activityAppId 媒体ID
     * @param activityId 活动ID
     * @param location 位置
     */
    DubboResult<Boolean> sort(Long activityAppId, Long activityId, int location);
}
