/**
 * Project Name:media-api File Name:MediaAppConfigDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年10月8日下午3:04:32 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:MediaAppConfigDto <br/>
 * Function: 媒体配置信息dto. <br/>
 * Date: 2016年10月8日 下午3:04:32 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class MediaAppConfigDto extends BaseDto {

    /** 序列号 */
    private static final long   serialVersionUID         = 6759094461494420438L;

    /** 计费方式分成 */
    public static final Integer CHARGE_TYPE_DIVIDED_INTO = 1;

    /** 计费方式CPC */
    public static final Integer CHARGE_TYPE_CPC          = 2;

    /** 计费方式CPM */
    public static final Integer CHARGE_TYPE_CPM          = 3;

    /** 扣量 */
    public static final Integer IS_DEDUCTED              = 1;

    /** 不扣量 */
    public static final Integer NO_DEDUCTED              = 0;

    /** 媒体Id */
    private Long                appId;
    /** 媒体名称 */
    private String              appName;
    /** 计费方式:1-分成;2-CPC;3-CPM;默认计费方式分成 */
    private Integer             chargeType;
    /** 价格 */
    private Long                price;
    /** 媒体分账比例 */
    private Integer             mediaSplitRatio;
    /** 平台分账比例 */
    private Integer             platformSplitRatio;
    /** 0-不扣量;1-扣量;默认为1-扣量 */
    private Integer             isDeducted;
    /** 扣量比例：% */
    private Integer             deductedPercent;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Integer getMediaSplitRatio() {
        return mediaSplitRatio;
    }

    public void setMediaSplitRatio(Integer mediaSplitRatio) {
        this.mediaSplitRatio = mediaSplitRatio;
    }

    public Integer getPlatformSplitRatio() {
        return platformSplitRatio;
    }

    public void setPlatformSplitRatio(Integer platformSplitRatio) {
        this.platformSplitRatio = platformSplitRatio;
    }

    public Integer getIsDeducted() {
        return isDeducted;
    }

    public void setIsDeducted(Integer isDeducted) {
        this.isDeducted = isDeducted;
    }

    public Integer getDeductedPercent() {
        return deductedPercent;
    }

    public void setDeductedPercent(Integer deductedPercent) {
        this.deductedPercent = deductedPercent;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
