/**
 * Project Name:media-api<br>
 * File Name:SlotCacheDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年10月19日下午7:23:05<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: SlotCacheDto <br/>
 * Function: 屏蔽策略缓存对象. <br/>
 * date: 2016年10月19日 下午7:23:05 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class SlotCacheDto implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long              id;

    /** 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙. */
    private Integer           slotType;

    /** 主图尺寸-宽. */
    private int               pictureWidth;

    /** 主图尺寸-高. */
    private int               pictureHeight;

    /** 屏蔽策略ID. */
    private Long              strategyId;

    public SlotCacheDto(Long id, Integer slotType, int width, int height, Long strategyId) {
        super();
        this.id = id;
        this.slotType = slotType;
        this.pictureWidth = width;
        this.pictureHeight = height;
        this.strategyId = strategyId;
    }

    public SlotCacheDto() {
        super();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSlotType() {
        return slotType;
    }

    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    public int getPictureWidth() {
        return pictureWidth;
    }

    public void setPictureWidth(int pictureWidth) {
        this.pictureWidth = pictureWidth;
    }

    public int getPictureHeight() {
        return pictureHeight;
    }

    public void setPictureHeight(int pictureHeight) {
        this.pictureHeight = pictureHeight;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
