/**
 * Project Name:media-api<br>
 * File Name:ShieldStrategyBaseDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年9月29日下午3:19:22<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: ShieldStrategyBaseDto <br/>
 * Function: 屏蔽策略信息. <br/>
 * date: 2016年9月29日 下午3:19:22 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class StrategyDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 屏蔽行业列表，中间以逗号隔开. */
    private String            shieldIndustries;

    /** 屏蔽广告主URL列表， 中间以逗号隔开. */
    private String            shieldUrls;

    public StrategyDto() {
        super();
    }

    public StrategyDto(String shieldIndustries, String shieldUrls) {
        super();
        this.shieldIndustries = shieldIndustries;
        this.shieldUrls = shieldUrls;
    }

    public String getShieldIndustries() {
        return shieldIndustries;
    }

    public void setShieldIndustries(String shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    public String getShieldUrls() {
        return shieldUrls;
    }

    public void setShieldUrls(String shieldUrls) {
        this.shieldUrls = shieldUrls;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
