/**
 * Project Name:media-api<br>
 * File Name:ReqUpdateSlotStrategy.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto.req<br>
 * Date:2016年10月19日下午5:18:28<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.api.dto.req;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: ReqUpdateSlotStrategy <br/>
 * date: 2016年10月19日 下午5:18:28 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class ReqUpdateSlotStrategy implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 6418438363278489238L;

    @ApiModelProperty(value = "屏蔽策略", required = false)
    private Long              strategyId;

    /** 屏蔽行业列表，中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽行业列表，中间以逗号隔开", required = false)
    private List<String>      shieldIndustries;

    /** 屏蔽广告主URL列表， 中间以逗号隔开. */
    @ApiModelProperty(value = "屏蔽广告主URL列表， 中间以逗号隔开", required = false)
    private List<String>      shieldAdvertisers;

    /**
     * shieldIndustries.
     *
     * @return the shieldIndustries
     * @since JDK 1.6
     */
    public List<String> getShieldIndustries() {
        return shieldIndustries;
    }

    /**
     * shieldIndustries.
     *
     * @param shieldIndustries the shieldIndustries to set
     * @since JDK 1.6
     */
    public void setShieldIndustries(List<String> shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    /**
     * shieldAdvertisers.
     *
     * @return the shieldAdvertisers
     * @since JDK 1.6
     */
    public List<String> getShieldAdvertisers() {
        return shieldAdvertisers;
    }

    /**
     * shieldAdvertisers.
     *
     * @param shieldAdvertisers the shieldAdvertisers to set
     * @since JDK 1.6
     */
    public void setShieldAdvertisers(List<String> shieldAdvertisers) {
        this.shieldAdvertisers = shieldAdvertisers;
    }

    /**
     * strategyId.
     *
     * @return the strategyId
     * @since JDK 1.6
     */
    public Long getStrategyId() {
        return strategyId;
    }

    /**
     * strategyId.
     *
     * @param strategyId the strategyId to set
     * @since JDK 1.6
     */
    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
