/**
 * Project Name:media-api File Name:RspSlotDataStatisticsDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月13日下午8:20:08 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspSlotDataStatisticsDto <br/>
 * Function: 广告数据统计Dto. <br/>
 * Date: 2016年10月13日 下午8:20:08 <br/>
 * 
 * @author guayn
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspSlotDataStatisticsDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -7019648321036508754L;

    /** 广告位ID. */
    private Long              slotId;

    /** 广告位名称. */
    private String            slotName;

    /** 广告位类型. */
    private Integer           slotType;

    /** 曝光量. */
    private Long              exposureCount;

    /** 点击数. */
    private Long              clickCount;

    /** 预计收入. */
    private Long              consumeTotal;

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Integer getSlotType() {
        return slotType;
    }

    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public Long getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public Long getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Long getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
