/**
 * Project Name:media-api File Name:RspDataStatistics.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月11日下午2:27:11 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspDataStatistics <br/>
 * Function: 结算数据统计. <br/>
 * Date: 2016年10月11日 下午2:27:11 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class RspSlotLineStatisticsDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 2902137581196740720L;

    /** 当前日期 */
    private List<String>      curDate;
    /** 点击数. */
    private List<Long>     clickCount;
    /** 曝光量. */
    private List<Long>     exposureCount;
    /** 每一千次的有效价格. */
    private List<Long>        eCpm;
    /** 预计收入. */
    private List<Long>        consumeTotal;
    /** 点击率 */
    private List<Long>        clickRate;

    public List<String> getCurDate() {
        return curDate;
    }

    public void setCurDate(List<String> curDate) {
        this.curDate = curDate;
    }

    public List<Long> getClickCount() {
        return clickCount;
    }

    public void setClickCount(List<Long> clickCount) {
        this.clickCount = clickCount;
    }

    public List<Long> getExposureCount() {
        return exposureCount;
    }

    public void setExposureCount(List<Long> exposureCount) {
        this.exposureCount = exposureCount;
    }

    public List<Long> geteCpm() {
        return eCpm;
    }

    public void seteCpm(List<Long> eCpm) {
        this.eCpm = eCpm;
    }

    public List<Long> getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(List<Long> consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    public List<Long> getClickRate() {
        return clickRate;
    }

    public void setClickRate(List<Long> clickRate) {
        this.clickRate = clickRate;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
