/**
 * Project Name:media-api File Name:RemoteMediaAppConfigService.java Package
 * Name:cn.com.duiba.tuia.media.api.remoteservice Date:2016年10月8日下午2:56:34 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.media.api.remoteservice;

import cn.com.duiba.tuia.media.api.dto.MediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetMediaAppConfigByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppConfigDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteMediaAppConfigService <br/>
 * Function: tuia媒体app配置信息. <br/>
 * Date: 2016年10月8日 下午2:56:34 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteMediaAppConfigBackendService {

    /**
     * 媒体配置信息分页
     * 
     * @param req
     * @return
     */
    DubboResult<PageResultDto<RspMediaAppConfigDto>> getMediaAppConfigByPage(ReqGetMediaAppConfigByPageDto req);

    /**
     * 查看媒体配置信息
     * 
     * @param mediaId
     * @return
     */
    DubboResult<MediaAppConfigDto> getMediaAppConfig(Long mediaAppId);

    /**
     * 修改媒体配置信息
     * 
     * @param param
     * @return
     */
    DubboResult<Boolean> updateMediaAppConfig(ReqUpdateMediaAppConfigDto param);

}
