/**
 * Project Name:media-api<br>
 * File Name:MediaService.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.service<br>
 * Date:2016年9月29日下午2:12:54<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.remoteservice;

import cn.com.duiba.tuia.media.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.StrategyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteMediaService <br/>
 * Function: 推啊媒体服务. <br/>
 * date: 2016年9月29日 下午2:12:54 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface RemoteMediaService {

    /**
     * 查询屏蔽策略信息.<br>
     * [使用说明]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该广告位不存在时：returnCode=0304008</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     *
     * @param slotId the slot id
     * @return the strategy
     */
    DubboResult<StrategyDto> getStrategy(long slotId);

    /**
     * 查询媒体APP是否有效.<br>
     * [使用说明]<br>
     * true:有效<br>
     * false:无效<br>
     *
     * @param mediaAppId 媒体APPid
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> isValidMediaApp(long mediaAppId);

    /**
     * 查询媒体应用信息.<br>
     * [使用说明]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该媒体应用不存在时：returnCode=0401001</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     * 
     * @param mediaAppId 媒体应用ID
     * @return the media app
     */
    DubboResult<MediaAppDataDto> getMediaApp(long mediaAppId);

    /**
     * 查询媒体应用信息.<br>
     * [使用说明]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该媒体应用不存在时：returnCode=0401001</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     *
     * @param appKey the app key
     * @return the media app
     */
    DubboResult<MediaAppDataDto> getMediaAppByKey(String appKey);

    /**
     * 查询广告位信息.<br>
     * [使用说明]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该广告位不存在时：returnCode=0304008</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     *
     * @param slotId the slot id
     * @return the dubbo result< boolean>
     */
    DubboResult<SlotCacheDto> getSlot(long slotId);

    /**
     * 更新广告位的屏蔽策略缓存.<br>
     * [使用说明]
     * <ol>
     * <li>当发生数据库失败时：returnCode=0002001</li>
     * <li>当该广告位不存在时：returnCode=0304008</li>
     * <li>当发生其他错误时：returnCode=9999999</li>
     * </ol>
     *
     * @param slotId 广告位id
     * @return the dubbo result< strategy dto>
     */
    DubboResult<StrategyDto> updateStrategy(long slotId);
}
