/**
 * Project Name:media-api<br>
 * File Name:RspGetActivityData.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto.rsp<br>
 * Date:2016年10月18日上午10:51:19<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto.rsp;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.media.api.dto.BaseActivityDataDto;

/**
 * ClassName: RspGetActivityData <br/>
 * Function: 活动统计数据返回结果. <br/>
 * date: 2016年10月18日 上午10:51:19 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class RspGetActivityData extends BaseActivityDataDto implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** 活动名称. */
    private String            activityName;

    /** 活动类型编码. */
    private Integer           activityType;

    /** 活动ID. */
    private Long              activityId;

    /** 活动类型名称 */
    private String            activityTypeName;

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getActivityTypeName() {
        return activityTypeName;
    }

    public void setActivityTypeName(String activityTypeName) {
        this.activityTypeName = activityTypeName;
    }
}
