package cn.com.duiba.tuia.media.api.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityApp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAppDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public interface RemoteActivityAppBackendService {

    /**
     * 
     * getActivityAppByPage:(查询媒体接口). <br/>
     *
     * @author ZFZ
     * @param reqActivityApp 查询条件
     * @return
     * @since JDK 1.6
     */
    DubboResult<PageResultDto<RspActivityAppDto>> getActivityAppByPage(ReqActivityApp reqActivityApp);

    /**
     * 
     * addActivityApp:(添加媒体接口). <br/>
     *
     * @author ZFZ
     * @param activityAppIds 活动媒体ID列表
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addActivityApp(List<Long> activityAppIds);

    /**
     * 
     * removeActivityApp:(移除媒体). <br/>
     *
     * @author ZFZ
     * @param activityAppId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeActivityApp(Long activityAppId);

    /**
     * 
     * searchActivityApp:(添加定制媒体时的搜索接口). <br/>
     *
     * @author ZFZ
     * @param reqActivityApp 查询条件
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<RspActivityAppDto>> searchActivityApp(ReqActivityApp reqActivityApp);
}
