package cn.com.duiba.tuia.media.api.remoteservice;

import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public interface RemoteActivityBackendService {

    /**
     * 
     * getByActivityIds:(查询活动接口). <br/>
     *
     * @author ZFZ
     * @param activityIds 查询条件
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<RspActivityDto>> getByActivityIds(List<Long> activityIds);

    /**
     * 给活动推荐使用的接口，根据活动id和Type查找活动,status=1，isDelete=0
     *
     * @param id 活动ID
     * @param type 活动类型
     * @return 活动名称
     */
    DubboResult<String> getActivityNameByIdAndType(Long id, Integer type);
}
