package cn.com.duiba.tuia.media.api.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
public interface RemoteActivitySortBackendService {

    /**
     * 
     * getByCondition:(查询活动列表接口). <br/>
     *
     * @author ZFZ
     * @param reqActivitySort
     * @return
     * @since JDK 1.6
     */
    DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort);

    /**
     * 
     * addActivitySort:(添加活动接口). <br/>
     *
     * @author ZFZ
     * @param activityAppId
     * @param idAndTypes
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addActivitySort(Long activityAppId, List<ReqIdAndType> idAndTypes);

    /**
     * 
     * addDefaultActivitySort:(添加默认活动接口). <br/>
     *
     * @author ZFZ
     * @param activityAppId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> addDefaultActivitySort(Long activityAppId);

    /**
     * 
     * removeActivity:(移除活动接口). <br/>
     *
     * @author ZFZ
     * @param activityAppId 媒体ID，默认活动排序媒体ID为0
     * @param activityId 活动ID
     * @param activityType
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> removeActivity(Long activityAppId, Long activityId, Integer activityType);

    /**
     * 
     * sort:(排序接口). <br/>
     *
     * @author ZFZ
     * @param activityAppId 媒体ID
     * @param activityId 活动ID
     * @param activityType 位置
     * @param location
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> sort(Long activityAppId, Long activityId, Integer activityType, int location);

    /**
     * 给活动推荐引擎提供的查询媒体活动的接口
     * 
     * @param appId 活动媒体ID
     * @return 活动列表
     */
    DubboResult<List<RspActivityDto>> getActivityByApp(Long appId);
}
