/**
 * Project Name:media-api File Name:RemoteMediaAppService.java Package Name:cn.com.duiba.tuia.media.api.remoteservice
 * Date:2016年9月30日下午3:48:58 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.remoteservice;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteMediaAppService <br/>
 * Function: tuia媒体app信息服务. <br/>
 * Date: 2016年9月30日 下午3:48:58 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteMediaAppBackendService {

    /**
     * 
     * updateMediaAppStatus:(修改媒体应用信息状态). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateMediaAppStatus(ReqUpdateMediaAppStatusDto param);

    /**
     * 
     * getMediaApp:(查看媒体应用信息状态). <br/>
     *
     * @author ZFZ
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<MediaAppDto> getMediaApp(Long appId);
    
}
